/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Balance;
import de.adorsys.aspsp.xs2a.domain.BalanceType;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.aspsp.xs2a.service.AccountReferenceValidationService;
import de.adorsys.aspsp.xs2a.service.AccountService;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FundsConfirmationService {
    private final AccountService accountService;
    private final AccountReferenceValidationService referenceValidationService;

    public ResponseObject<FundsConfirmationResponse> fundsConfirmation(FundsConfirmationRequest request) {
        ResponseObject accountReferenceValidationResponse = this.referenceValidationService.validateAccountReferences(request.getAccountReferences());
        return accountReferenceValidationResponse.hasError() ? ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build() : ResponseObject.builder().body(new FundsConfirmationResponse(this.isFundsAvailable(request.getPsuAccount(), request.getInstructedAmount()))).build();
    }

    private boolean isFundsAvailable(AccountReference accountReference, Amount requiredAmount) {
        List<Balance> balances = this.getAccountBalancesByAccountReference(accountReference);
        return balances.stream().filter(bal -> BalanceType.INTERIM_AVAILABLE == bal.getBalanceType()).findFirst().map(Balance::getBalanceAmount).map(am -> this.isRequiredAmountEnough(requiredAmount, (Amount)am)).orElse(false);
    }

    private boolean isRequiredAmountEnough(Amount requiredAmount, Amount availableAmount) {
        return this.convertToBigDecimal(availableAmount.getContent()).compareTo(this.convertToBigDecimal(requiredAmount.getContent())) >= 0 && availableAmount.getCurrency() == requiredAmount.getCurrency();
    }

    private BigDecimal convertToBigDecimal(String content) {
        return Optional.ofNullable(content).map(BigDecimal::new).orElse(BigDecimal.ZERO);
    }

    private List<Balance> getAccountBalancesByAccountReference(AccountReference reference) {
        return Optional.ofNullable(reference).map(this.accountService::getAccountDetailsByAccountReference).filter(Optional::isPresent).map(Optional::get).map(AccountDetails::getBalances).orElseGet(Collections::emptyList);
    }

    @ConstructorProperties(value={"accountService", "referenceValidationService"})
    public FundsConfirmationService(AccountService accountService, AccountReferenceValidationService referenceValidationService) {
        this.accountService = accountService;
        this.referenceValidationService = referenceValidationService;
    }
}

