/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.mapper.consent.AisConsentMapper;
import de.adorsys.aspsp.xs2a.service.profile.AspspProfileService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiCreateAisConsentRequest;
import de.adorsys.aspsp.xs2a.spi.service.ConsentSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final AisConsentMapper aisConsentMapper;
    private final ConsentSpi consentSpi;
    private final AspspProfileService aspspProfileService;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, String psuId) {
        if (this.isInvalidBankOfferConsent(request)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PARAMETER_NOT_SUPPORTED))).build();
        }
        if (!this.isValidExpirationDate(request.getValidUntil())) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PERIOD_INVALID))).build();
        }
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PARAMETER_NOT_SUPPORTED))).build();
        }
        String tppId = "This is a test TppId";
        SpiCreateAisConsentRequest createAisConsentRequest = this.aisConsentMapper.mapToSpiCreateAisConsentRequest(request, psuId, tppId, new AspspConsentData("zzzzzzzzzzzzzz".getBytes()));
        String consentId = this.consentSpi.createConsent(createAisConsentRequest);
        return !StringUtils.isBlank((CharSequence)consentId) ? ResponseObject.builder().body(new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null)).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_400))).build();
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        return this.aisConsentMapper.mapToConsentStatus(this.consentSpi.getAccountConsentStatusById(consentId)).map(status -> ResponseObject.builder().body(new ConsentStatusResponse((ConsentStatus)((Object)status))).build()).orElseGet(() -> ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build());
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        if (this.consentSpi.getAccountConsentById(consentId) != null) {
            this.consentSpi.revokeConsent(consentId);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        AccountConsent consent = this.aisConsentMapper.mapToAccountConsent(this.consentSpi.getAccountConsentById(consentId));
        return consent == null ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build() : ResponseObject.builder().body(consent).build();
    }

    ResponseObject<AccountAccess> getValidatedConsent(String consentId) {
        AccountConsent consent = this.aisConsentMapper.mapToAccountConsent(this.consentSpi.getAccountConsentById(consentId));
        if (consent == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
        }
        if (!consent.isValidStatus()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_EXPIRED))).build();
        }
        if (!consent.isValidFrequency()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.ACCESS_EXCEEDED))).build();
        }
        return ResponseObject.builder().body(consent.getAccess()).build();
    }

    boolean isValidAccountByAccess(String iban, Currency currency, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getIban().equals(iban) && a.getCurrency() == currency);
    }

    private boolean isValidExpirationDate(LocalDate validUntil) {
        int consentLifetime = Math.abs(this.aspspProfileService.getConsentLifetime());
        return validUntil.isAfter(LocalDate.now()) && this.isValidConsentLifetime(consentLifetime, validUntil);
    }

    private boolean isValidConsentLifetime(int consentLifetime, LocalDate validUntil) {
        return consentLifetime == 0 || validUntil.isBefore(LocalDate.now().plusDays(consentLifetime));
    }

    private Boolean isNotEmptyAccess(AccountAccess access) {
        return Optional.ofNullable(access).map(AccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return request.getAccess().getAllPsd2() == AccountAccessType.ALL_ACCOUNTS && CollectionUtils.isEmpty(request.getAccountReferences()) && this.aspspProfileService.getAllPsd2Support() == false;
    }

    private boolean isInvalidBankOfferConsent(CreateConsentReq request) {
        return !this.aspspProfileService.isBankOfferedConsentSupported() && this.isNotEmptyAccess(request.getAccess()) == false;
    }

    @ConstructorProperties(value={"aisConsentMapper", "consentSpi", "aspspProfileService"})
    public ConsentService(AisConsentMapper aisConsentMapper, ConsentSpi consentSpi, AspspProfileService aspspProfileService) {
        this.aisConsentMapper = aisConsentMapper;
        this.consentSpi = consentSpi;
        this.aspspProfileService = aspspProfileService;
    }
}

