/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.Balance;
import de.adorsys.aspsp.xs2a.domain.BookingStatus;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.Transactions;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.account.AccountReport;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.ConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.service.mapper.consent.AisConsentMapper;
import de.adorsys.aspsp.xs2a.service.validator.ValueValidatorService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import de.adorsys.aspsp.xs2a.spi.service.ConsentSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    private final AccountSpi accountSpi;
    private final AccountMapper accountMapper;
    private final ValueValidatorService validatorService;
    private final ConsentService consentService;
    private final ConsentSpi consentSpi;
    private final AisConsentMapper consentMapper;
    private static final String TPP_ID = "This is a test TppId";

    public ResponseObject<Map<String, List<AccountDetails>>> getAccountDetailsList(String consentId, boolean withBalance) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        List<AccountDetails> accountDetails = this.getAccountDetailsFromReferences(withBalance, allowedAccountData.getBody());
        ResponseObject<Map<String, List<AccountDetails>>> response = accountDetails.isEmpty() ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build() : ResponseObject.builder().body(Collections.singletonMap("accountList", accountDetails)).build();
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(withBalance, TypeAccess.ACCOUNT, response));
        return response;
    }

    public ResponseObject<AccountDetails> getAccountDetails(String consentId, String accountId, boolean withBalance) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails((SpiAccountDetails)this.accountSpi.readAccountDetails(accountId, new AspspConsentData()).getPayload());
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = withBalance ? this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getBalances()) : this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getAccounts());
        ResponseObject.ResponseBuilder<Object> builder = ResponseObject.builder();
        builder = isValid ? (withBalance ? builder.body(accountDetails) : builder.body(this.accountMapper.mapToAccountDetailNoBalances(accountDetails))) : builder.fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID)));
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(withBalance, TypeAccess.ACCOUNT, builder.build()));
        return builder.build();
    }

    public ResponseObject<List<Balance>> getBalances(String consentId, String accountId) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails((SpiAccountDetails)this.accountSpi.readAccountDetails(accountId, new AspspConsentData()).getPayload());
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getBalances());
        ResponseObject<List<Balance>> response = isValid ? ResponseObject.builder().body(accountDetails.getBalances()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(false, TypeAccess.BALANCE, response));
        return response;
    }

    public ResponseObject<AccountReport> getAccountReport(String consentId, String accountId, LocalDate dateFrom, LocalDate dateTo, String transactionId, boolean psuInvolved, BookingStatus bookingStatus, boolean withBalance, boolean deltaList) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails((SpiAccountDetails)this.accountSpi.readAccountDetails(accountId, new AspspConsentData()).getPayload());
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getTransactions());
        Optional<AccountReport> report = this.getAccountReport(accountId, dateFrom, dateTo, transactionId, bookingStatus);
        ResponseObject<AccountReport> response = isValid && report.isPresent() ? ResponseObject.builder().body(report.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(withBalance, TypeAccess.TRANSACTION, response));
        return response;
    }

    public ResponseObject<AccountReport> getAccountReportByPeriod(String consentId, String accountId, LocalDate dateFrom, LocalDate dateTo, BookingStatus bookingStatus, boolean withBalance) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails((SpiAccountDetails)this.accountSpi.readAccountDetails(accountId, new AspspConsentData()).getPayload());
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getTransactions());
        Optional<AccountReport> report = this.getAccountReportByPeriod(accountId, dateFrom, dateTo).map(r -> this.filterByBookingStatus((AccountReport)r, bookingStatus));
        ResponseObject<AccountReport> response = isValid && report.isPresent() ? ResponseObject.builder().body(report.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(withBalance, TypeAccess.TRANSACTION, response));
        return response;
    }

    public ResponseObject<AccountReport> getAccountReportByTransactionId(String consentId, String accountId, String transactionId) {
        ResponseObject<AccountAccess> allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails((SpiAccountDetails)this.accountSpi.readAccountDetails(accountId, new AspspConsentData()).getPayload());
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), allowedAccountData.getBody().getTransactions());
        Optional<AccountReport> report = this.getAccountReportByTransaction(transactionId, accountId);
        ResponseObject<AccountReport> response = isValid && report.isPresent() ? ResponseObject.builder().body(report.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.consentSpi.consentActionLog(TPP_ID, consentId, this.createActionStatus(false, TypeAccess.TRANSACTION, response));
        return response;
    }

    private List<AccountDetails> getAccountDetailsFromReferences(boolean withBalance, AccountAccess accountAccess) {
        List<AccountReference> references = withBalance ? accountAccess.getBalances() : accountAccess.getAccounts();
        List<AccountDetails> details = this.getAccountDetailsFromReferences(references);
        return withBalance ? details : this.accountMapper.mapToAccountDetailsListNoBalances(details);
    }

    private List<AccountDetails> getAccountDetailsFromReferences(List<AccountReference> references) {
        return CollectionUtils.isEmpty(references) ? Collections.emptyList() : references.stream().map(this::getAccountDetailsByAccountReference).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<AccountReport> getAccountReport(String accountId, LocalDate dateFrom, LocalDate dateTo, String transactionId, BookingStatus bookingStatus) {
        return StringUtils.isNotBlank((CharSequence)transactionId) ? this.getAccountReportByTransaction(transactionId, accountId) : this.getAccountReportByPeriod(accountId, dateFrom, dateTo).map(r -> this.filterByBookingStatus((AccountReport)r, bookingStatus));
    }

    private Optional<AccountReport> getAccountReportByTransaction(String transactionId, String accountId) {
        this.validatorService.validateAccountIdTransactionId(accountId, transactionId);
        Optional transaction = (Optional)this.accountSpi.readTransactionById(transactionId, accountId, new AspspConsentData()).getPayload();
        return this.accountMapper.mapToAccountReport(transaction.map(Collections::singletonList).orElseGet(Collections::emptyList));
    }

    private Optional<AccountReport> getAccountReportByPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        LocalDate dateToChecked = Optional.ofNullable(dateTo).orElseGet(LocalDate::now);
        this.validatorService.validateAccountIdPeriod(accountId, dateFrom, dateToChecked);
        return this.accountMapper.mapToAccountReport((List)this.accountSpi.readTransactionsByPeriod(accountId, dateFrom, dateTo, new AspspConsentData()).getPayload());
    }

    public Optional<AccountDetails> getAccountDetailsByAccountReference(AccountReference reference) {
        return Optional.ofNullable(reference).map(ref -> (List)this.accountSpi.readAccountDetailsByIban(ref.getIban(), new AspspConsentData()).getPayload()).map(Collection::stream).flatMap(accDts -> accDts.filter(spiAcc -> spiAcc.getCurrency() == reference.getCurrency()).findFirst()).map(this.accountMapper::mapToAccountDetails);
    }

    private ActionStatus createActionStatus(boolean withBalance, TypeAccess access, ResponseObject response) {
        return response.hasError() ? this.consentMapper.mapActionStatusError(response.getError().getTppMessage().getMessageErrorCode(), withBalance, access) : ActionStatus.SUCCESS;
    }

    private AccountReport filterByBookingStatus(AccountReport report, BookingStatus bookingStatus) {
        return new AccountReport(EnumSet.of(BookingStatus.BOOKED, BookingStatus.BOTH).contains((Object)bookingStatus) ? report.getBooked() : new Transactions[]{}, EnumSet.of(BookingStatus.PENDING, BookingStatus.BOTH).contains((Object)bookingStatus) ? report.getPending() : new Transactions[]{});
    }

    @ConstructorProperties(value={"accountSpi", "accountMapper", "validatorService", "consentService", "consentSpi", "consentMapper"})
    public AccountService(AccountSpi accountSpi, AccountMapper accountMapper, ValueValidatorService validatorService, ConsentService consentService, ConsentSpi consentSpi, AisConsentMapper consentMapper) {
        this.accountSpi = accountSpi;
        this.accountMapper = accountMapper;
        this.validatorService = validatorService;
        this.consentService = consentService;
        this.consentSpi = consentSpi;
        this.consentMapper = consentMapper;
    }
}

