/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.exception;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.service.message.MessageService;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
public class GlobalExceptionHandlerController {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerController.class);
    private MessageService messageService;

    @Autowired
    public GlobalExceptionHandlerController(MessageService messageService) {
        this.messageService = messageService;
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity validationException(ValidationException ex, HandlerMethod handlerMethod) {
        log.warn("ValidationException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getMessageError(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity httpMessageException(HttpMessageNotReadableException ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getMessageError(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity mediaTypeNotSupportedException(HttpMediaTypeNotAcceptableException ex, HandlerMethod handlerMethod) {
        log.warn("Media type unsupported exception: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)HttpStatus.UNSUPPORTED_MEDIA_TYPE.getReasonPhrase(), HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity exception(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        return new ResponseEntity((Object)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity restException(RestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)new MessageError(new TppMessageInformation(MessageCategory.ERROR, ex.getMessageErrorCode()).text(ex.getMessage())), ex.getHttpStatus());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity requestBodyValidationException(MethodArgumentNotValidException ex, HandlerMethod handlerMethod) {
        log.warn("RequestBodyValidationException handled in controller: {}, message: {} ", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getMessageError(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    private MessageError getMessageError(MessageErrorCode errorCode) {
        TppMessageInformation messageInformation = new TppMessageInformation(MessageCategory.ERROR, errorCode);
        messageInformation.setText(this.messageService.getMessage(errorCode.name()));
        return new MessageError(TransactionStatus.RJCT, messageInformation);
    }
}

