/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.aspsp.xs2a.domain.code.FrequencyCode;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="Periodic Payment Initialisation Request", value="Periodic Payment")
public class PeriodicPayment
extends SinglePayment {
    @NotNull
    @ApiModelProperty(name="startDate", required=true, example="2020-01-01")
    private LocalDate startDate;
    @ApiModelProperty(name="executionRule", required=false, example="preceding")
    private String executionRule;
    @ApiModelProperty(name="endDate", required=false, example="2020-02-01")
    private LocalDate endDate;
    @NotNull
    @ApiModelProperty(name="frequency", required=true, example="ANNUAL")
    private FrequencyCode frequency;
    @Min(value=1L)
    @Max(value=31L)
    @ApiModelProperty(name="dayOfExecution", required=false, example="14")
    private @Min(value=1L) @Max(value=31L) int dayOfExecution;

    @JsonIgnore
    public boolean areValidExecutionAndPeriodDates() {
        return this.isValidExecutionDateAndTime() && this.isValidPeriod();
    }

    @JsonIgnore
    private boolean isValidPeriod() {
        return this.isValidStartDate() && Optional.ofNullable(this.endDate).map(d -> d.isAfter(this.startDate)).orElse(true) != false;
    }

    @JsonIgnore
    private boolean isValidStartDate() {
        return this.startDate.isEqual(ChronoLocalDate.from(LocalDate.now())) || this.startDate.isAfter(ChronoLocalDate.from(LocalDate.now()));
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public int getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(int dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    @Override
    public String toString() {
        return "PeriodicPayment(startDate=" + this.getStartDate() + ", executionRule=" + this.getExecutionRule() + ", endDate=" + this.getEndDate() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", dayOfExecution=" + this.getDayOfExecution() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodicPayment)) {
            return false;
        }
        PeriodicPayment other = (PeriodicPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        FrequencyCode this$frequency = this.getFrequency();
        FrequencyCode other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        return this.getDayOfExecution() == other.getDayOfExecution();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PeriodicPayment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        FrequencyCode $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        result = result * 59 + this.getDayOfExecution();
        return result;
    }
}

