/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.NotNull;

@ApiModel(description="BulkPayment Initialisation Request", value="BulkPayments")
public class BulkPayment {
    @ApiModelProperty(value="If this element equals \"true\", the PSU prefers only one booking entry. If this element equals \"false\", the PSU prefers individual booking of all contained individual transactions. The ASPSP will follow this preference according to contracts agreed on with the PSU.", example="true")
    private Boolean batchBookingPreferred;
    @NotNull
    @ApiModelProperty(value="debtor account", required=true)
    private AccountReference debtorAccount;
    @ApiModelProperty(value="requested execution date", example="2020-01-01")
    private LocalDate requestedExecutionDate;
    @ApiModelProperty(value="The Bulk Entry Type is a type which follows the JSON formats for the supported products for single payments, see Section 11.1, excluding the data elements\n\uf0b7 debtorAccount,\n\uf0b7 requestedExecutionDate,\n\uf0b7 requestedExecutionTime.\nThese three data elements may not be contained in any bulk entry.", required=true)
    List<SinglePayment> payments;

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public List<SinglePayment> getPayments() {
        return this.payments;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setPayments(List<SinglePayment> payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkPayment)) {
            return false;
        }
        BulkPayment other = (BulkPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        if (this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        List<SinglePayment> this$payments = this.getPayments();
        List<SinglePayment> other$payments = other.getPayments();
        return !(this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BulkPayment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        List<SinglePayment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        return result;
    }

    public String toString() {
        return "BulkPayment(batchBookingPreferred=" + this.getBatchBookingPreferred() + ", debtorAccount=" + this.getDebtorAccount() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", payments=" + this.getPayments() + ")";
    }
}

