/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ApiModel(description="AccountAccess type", value="AccountAccessType")
public enum AccountAccessType {
    ALL_ACCOUNTS("allAccounts"),
    ALL_ACCOUNTS_WITH_BALANCES("allAccountsWithBalances");

    private static Map<String, AccountAccessType> container;
    @ApiModelProperty(value="description", example="allAccounts")
    private String description;

    @JsonCreator
    private AccountAccessType(String description) {
        this.description = description;
    }

    @JsonValue
    public String getDescription() {
        return this.description;
    }

    public static Optional<AccountAccessType> getByDescription(String description) {
        return Optional.ofNullable(container.get(description));
    }

    static {
        container = new HashMap<String, AccountAccessType>();
        Arrays.stream(AccountAccessType.values()).forEach(aat -> container.put(aat.getDescription(), (AccountAccessType)((Object)aat)));
    }
}

