/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.aspsp;

import de.adorsys.aspsp.xs2a.domain.account.SupportedAccountReferenceField;
import java.beans.ConstructorProperties;
import java.util.List;

public final class AspspSettings {
    private final int frequencyPerDay;
    private final boolean combinedServiceIndicator;
    private final List<String> availablePaymentProducts;
    private final List<String> availablePaymentTypes;
    private final boolean tppSignatureRequired;
    private final String pisRedirectUrlToAspsp;
    private final String aisRedirectUrlToAspsp;
    private final String multicurrencyAccountLevel;
    private final boolean bankOfferedConsentSupport;
    private final List<String> availableBookingStatuses;
    private final List<SupportedAccountReferenceField> supportedAccountReferenceFields;
    private final int consentLifetime;
    private final int transactionLifetime;
    private final boolean allPsd2Support;
    private final String authorisationStartType;

    @ConstructorProperties(value={"frequencyPerDay", "combinedServiceIndicator", "availablePaymentProducts", "availablePaymentTypes", "tppSignatureRequired", "pisRedirectUrlToAspsp", "aisRedirectUrlToAspsp", "multicurrencyAccountLevel", "bankOfferedConsentSupport", "availableBookingStatuses", "supportedAccountReferenceFields", "consentLifetime", "transactionLifetime", "allPsd2Support", "authorisationStartType"})
    public AspspSettings(int frequencyPerDay, boolean combinedServiceIndicator, List<String> availablePaymentProducts, List<String> availablePaymentTypes, boolean tppSignatureRequired, String pisRedirectUrlToAspsp, String aisRedirectUrlToAspsp, String multicurrencyAccountLevel, boolean bankOfferedConsentSupport, List<String> availableBookingStatuses, List<SupportedAccountReferenceField> supportedAccountReferenceFields, int consentLifetime, int transactionLifetime, boolean allPsd2Support, String authorisationStartType) {
        this.frequencyPerDay = frequencyPerDay;
        this.combinedServiceIndicator = combinedServiceIndicator;
        this.availablePaymentProducts = availablePaymentProducts;
        this.availablePaymentTypes = availablePaymentTypes;
        this.tppSignatureRequired = tppSignatureRequired;
        this.pisRedirectUrlToAspsp = pisRedirectUrlToAspsp;
        this.aisRedirectUrlToAspsp = aisRedirectUrlToAspsp;
        this.multicurrencyAccountLevel = multicurrencyAccountLevel;
        this.bankOfferedConsentSupport = bankOfferedConsentSupport;
        this.availableBookingStatuses = availableBookingStatuses;
        this.supportedAccountReferenceFields = supportedAccountReferenceFields;
        this.consentLifetime = consentLifetime;
        this.transactionLifetime = transactionLifetime;
        this.allPsd2Support = allPsd2Support;
        this.authorisationStartType = authorisationStartType;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public List<String> getAvailablePaymentProducts() {
        return this.availablePaymentProducts;
    }

    public List<String> getAvailablePaymentTypes() {
        return this.availablePaymentTypes;
    }

    public boolean isTppSignatureRequired() {
        return this.tppSignatureRequired;
    }

    public String getPisRedirectUrlToAspsp() {
        return this.pisRedirectUrlToAspsp;
    }

    public String getAisRedirectUrlToAspsp() {
        return this.aisRedirectUrlToAspsp;
    }

    public String getMulticurrencyAccountLevel() {
        return this.multicurrencyAccountLevel;
    }

    public boolean isBankOfferedConsentSupport() {
        return this.bankOfferedConsentSupport;
    }

    public List<String> getAvailableBookingStatuses() {
        return this.availableBookingStatuses;
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        return this.supportedAccountReferenceFields;
    }

    public int getConsentLifetime() {
        return this.consentLifetime;
    }

    public int getTransactionLifetime() {
        return this.transactionLifetime;
    }

    public boolean isAllPsd2Support() {
        return this.allPsd2Support;
    }

    public String getAuthorisationStartType() {
        return this.authorisationStartType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspspSettings)) {
            return false;
        }
        AspspSettings other = (AspspSettings)o;
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        List<String> this$availablePaymentProducts = this.getAvailablePaymentProducts();
        List<String> other$availablePaymentProducts = other.getAvailablePaymentProducts();
        if (this$availablePaymentProducts == null ? other$availablePaymentProducts != null : !((Object)this$availablePaymentProducts).equals(other$availablePaymentProducts)) {
            return false;
        }
        List<String> this$availablePaymentTypes = this.getAvailablePaymentTypes();
        List<String> other$availablePaymentTypes = other.getAvailablePaymentTypes();
        if (this$availablePaymentTypes == null ? other$availablePaymentTypes != null : !((Object)this$availablePaymentTypes).equals(other$availablePaymentTypes)) {
            return false;
        }
        if (this.isTppSignatureRequired() != other.isTppSignatureRequired()) {
            return false;
        }
        String this$pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        String other$pisRedirectUrlToAspsp = other.getPisRedirectUrlToAspsp();
        if (this$pisRedirectUrlToAspsp == null ? other$pisRedirectUrlToAspsp != null : !this$pisRedirectUrlToAspsp.equals(other$pisRedirectUrlToAspsp)) {
            return false;
        }
        String this$aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        String other$aisRedirectUrlToAspsp = other.getAisRedirectUrlToAspsp();
        if (this$aisRedirectUrlToAspsp == null ? other$aisRedirectUrlToAspsp != null : !this$aisRedirectUrlToAspsp.equals(other$aisRedirectUrlToAspsp)) {
            return false;
        }
        String this$multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        String other$multicurrencyAccountLevel = other.getMulticurrencyAccountLevel();
        if (this$multicurrencyAccountLevel == null ? other$multicurrencyAccountLevel != null : !this$multicurrencyAccountLevel.equals(other$multicurrencyAccountLevel)) {
            return false;
        }
        if (this.isBankOfferedConsentSupport() != other.isBankOfferedConsentSupport()) {
            return false;
        }
        List<String> this$availableBookingStatuses = this.getAvailableBookingStatuses();
        List<String> other$availableBookingStatuses = other.getAvailableBookingStatuses();
        if (this$availableBookingStatuses == null ? other$availableBookingStatuses != null : !((Object)this$availableBookingStatuses).equals(other$availableBookingStatuses)) {
            return false;
        }
        List<SupportedAccountReferenceField> this$supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        List<SupportedAccountReferenceField> other$supportedAccountReferenceFields = other.getSupportedAccountReferenceFields();
        if (this$supportedAccountReferenceFields == null ? other$supportedAccountReferenceFields != null : !((Object)this$supportedAccountReferenceFields).equals(other$supportedAccountReferenceFields)) {
            return false;
        }
        if (this.getConsentLifetime() != other.getConsentLifetime()) {
            return false;
        }
        if (this.getTransactionLifetime() != other.getTransactionLifetime()) {
            return false;
        }
        if (this.isAllPsd2Support() != other.isAllPsd2Support()) {
            return false;
        }
        String this$authorisationStartType = this.getAuthorisationStartType();
        String other$authorisationStartType = other.getAuthorisationStartType();
        return !(this$authorisationStartType == null ? other$authorisationStartType != null : !this$authorisationStartType.equals(other$authorisationStartType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        List<String> $availablePaymentProducts = this.getAvailablePaymentProducts();
        result = result * 59 + ($availablePaymentProducts == null ? 43 : ((Object)$availablePaymentProducts).hashCode());
        List<String> $availablePaymentTypes = this.getAvailablePaymentTypes();
        result = result * 59 + ($availablePaymentTypes == null ? 43 : ((Object)$availablePaymentTypes).hashCode());
        result = result * 59 + (this.isTppSignatureRequired() ? 79 : 97);
        String $pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        result = result * 59 + ($pisRedirectUrlToAspsp == null ? 43 : $pisRedirectUrlToAspsp.hashCode());
        String $aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        result = result * 59 + ($aisRedirectUrlToAspsp == null ? 43 : $aisRedirectUrlToAspsp.hashCode());
        String $multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        result = result * 59 + ($multicurrencyAccountLevel == null ? 43 : $multicurrencyAccountLevel.hashCode());
        result = result * 59 + (this.isBankOfferedConsentSupport() ? 79 : 97);
        List<String> $availableBookingStatuses = this.getAvailableBookingStatuses();
        result = result * 59 + ($availableBookingStatuses == null ? 43 : ((Object)$availableBookingStatuses).hashCode());
        List<SupportedAccountReferenceField> $supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        result = result * 59 + ($supportedAccountReferenceFields == null ? 43 : ((Object)$supportedAccountReferenceFields).hashCode());
        result = result * 59 + this.getConsentLifetime();
        result = result * 59 + this.getTransactionLifetime();
        result = result * 59 + (this.isAllPsd2Support() ? 79 : 97);
        String $authorisationStartType = this.getAuthorisationStartType();
        result = result * 59 + ($authorisationStartType == null ? 43 : $authorisationStartType.hashCode());
        return result;
    }

    public String toString() {
        return "AspspSettings(frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", availablePaymentProducts=" + this.getAvailablePaymentProducts() + ", availablePaymentTypes=" + this.getAvailablePaymentTypes() + ", tppSignatureRequired=" + this.isTppSignatureRequired() + ", pisRedirectUrlToAspsp=" + this.getPisRedirectUrlToAspsp() + ", aisRedirectUrlToAspsp=" + this.getAisRedirectUrlToAspsp() + ", multicurrencyAccountLevel=" + this.getMulticurrencyAccountLevel() + ", bankOfferedConsentSupport=" + this.isBankOfferedConsentSupport() + ", availableBookingStatuses=" + this.getAvailableBookingStatuses() + ", supportedAccountReferenceFields=" + this.getSupportedAccountReferenceFields() + ", consentLifetime=" + this.getConsentLifetime() + ", transactionLifetime=" + this.getTransactionLifetime() + ", allPsd2Support=" + this.isAllPsd2Support() + ", authorisationStartType=" + this.getAuthorisationStartType() + ")";
    }
}

