/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Size;

@ApiModel(description="Tpp Message Information", value="TppMessageInformation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TppMessageInformation {
    @ApiModelProperty(value="Category of the error, Only \u201dERROR\u201d or \"WARNING\" permitted", required=true, example="Error")
    private MessageCategory category;
    @ApiModelProperty(value="Code", required=true)
    @JsonProperty(value="code")
    private MessageErrorCode messageErrorCode;
    @ApiModelProperty(value="Path")
    private String path;
    @ApiModelProperty(value="Additional explanation text", example="Additional text information of the ASPSP up to 512 characters")
    @Size(max=512)
    private @Size(max=512) String text;

    public TppMessageInformation(MessageCategory category, MessageErrorCode messageErrorCode) {
        this.category = category;
        this.messageErrorCode = messageErrorCode;
    }

    public TppMessageInformation path(String path) {
        this.path = path;
        return this;
    }

    public TppMessageInformation text(String text) {
        this.text = text;
        return this;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public MessageErrorCode getMessageErrorCode() {
        return this.messageErrorCode;
    }

    public String getPath() {
        return this.path;
    }

    public String getText() {
        return this.text;
    }

    public void setCategory(MessageCategory category) {
        this.category = category;
    }

    public void setMessageErrorCode(MessageErrorCode messageErrorCode) {
        this.messageErrorCode = messageErrorCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "TppMessageInformation(category=" + (Object)((Object)this.getCategory()) + ", messageErrorCode=" + (Object)((Object)this.getMessageErrorCode()) + ", path=" + this.getPath() + ", text=" + this.getText() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppMessageInformation)) {
            return false;
        }
        TppMessageInformation other = (TppMessageInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageCategory this$category = this.getCategory();
        MessageCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        MessageErrorCode this$messageErrorCode = this.getMessageErrorCode();
        MessageErrorCode other$messageErrorCode = other.getMessageErrorCode();
        if (this$messageErrorCode == null ? other$messageErrorCode != null : !((Object)((Object)this$messageErrorCode)).equals((Object)other$messageErrorCode)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppMessageInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        MessageErrorCode $messageErrorCode = this.getMessageErrorCode();
        result = result * 59 + ($messageErrorCode == null ? 43 : ((Object)((Object)$messageErrorCode)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

