/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config.rest.profile;

import de.adorsys.aspsp.xs2a.config.rest.profile.AspspProfileRestErrorHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
public class AspspProfileRestConfig {
    @Value(value="${http-client.read-timeout.ms:10000}")
    private int readTimeout;
    @Value(value="${http-client.connection-timeout.ms:10000}")
    private int connectionTimeout;

    @Bean(name={"aspspProfileRestTemplate"})
    public RestTemplate aspspProfileRestTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().removeIf(m -> m.getClass().getName().equals(MappingJackson2XmlHttpMessageConverter.class.getName()));
        rest.setErrorHandler((ResponseErrorHandler)new AspspProfileRestErrorHandler());
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }
}

