/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="keycloak")
public class KeycloakConfigProperties {
    private String realm;
    private String resource;
    private Credentials credentials;
    private String authServerUrl;

    public String getRootPath() {
        return this.authServerUrl + "/realms/" + this.realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getResource() {
        return this.resource;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeycloakConfigProperties)) {
            return false;
        }
        KeycloakConfigProperties other = (KeycloakConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$realm = this.getRealm();
        String other$realm = other.getRealm();
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$authServerUrl = this.getAuthServerUrl();
        String other$authServerUrl = other.getAuthServerUrl();
        return !(this$authServerUrl == null ? other$authServerUrl != null : !this$authServerUrl.equals(other$authServerUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeycloakConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $authServerUrl = this.getAuthServerUrl();
        result = result * 59 + ($authServerUrl == null ? 43 : $authServerUrl.hashCode());
        return result;
    }

    public String toString() {
        return "KeycloakConfigProperties(realm=" + this.getRealm() + ", resource=" + this.getResource() + ", credentials=" + this.getCredentials() + ", authServerUrl=" + this.getAuthServerUrl() + ")";
    }

    public static class Credentials {
        private String secret;

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }

        public String toString() {
            return "KeycloakConfigProperties.Credentials(secret=" + this.getSecret() + ")";
        }
    }
}

