/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.interceptor;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.service.validator.RequestValidatorService;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class HandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(HandlerInterceptor.class);
    private final RequestValidatorService requestValidatorService;

    @Autowired
    public HandlerInterceptor(RequestValidatorService requestValidatorService) {
        this.requestValidatorService = requestValidatorService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValidAndSendRespIfError(request, response, handler);
    }

    private boolean isRequestValidAndSendRespIfError(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Map<String, String> violationsMap = this.requestValidatorService.getRequestViolationMap(request, handler);
        if (violationsMap.isEmpty()) {
            return true;
        }
        Map.Entry<String, String> firstError = violationsMap.entrySet().iterator().next();
        MessageErrorCode messageCode = this.getActualMessageErrorCode(firstError.getKey());
        log.debug("Handled error {}", (Object)(messageCode.name() + ": " + firstError.getValue()));
        response.sendError(messageCode.getCode(), messageCode.name() + ": " + firstError.getValue());
        return false;
    }

    private MessageErrorCode getActualMessageErrorCode(String error) {
        return MessageErrorCode.getByName(error).orElse(MessageErrorCode.FORMAT_ERROR);
    }
}

