/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.filter;

import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.psd2.validator.certificate.CertificateValidatorFactory;
import de.adorsys.psd2.validator.certificate.util.CertificateExtractorUtil;
import de.adorsys.psd2.validator.certificate.util.CertificateUtils;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import java.io.IOException;
import java.security.cert.CertificateException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.util.SimpleCertificateBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class CertificateFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CertificateFilter.class);
    private SimpleCertificateBucket blockedCertBucket;
    private SimpleCertificateBucket rootCertBucket;
    private SimpleCertificateBucket intermediateCertBucket;
    @Autowired
    private AspspProfileService aspspProfileService;

    public void init(FilterConfig filterConfig) {
        this.blockedCertBucket = new SimpleCertificateBucket(CertificateUtils.getCertificates((String)"blockedcert", (String[])new String[0]));
        this.rootCertBucket = new SimpleCertificateBucket(CertificateUtils.getCertificates((String)"rootcert", (String[])new String[]{"MyRootCA.pem"}));
        this.intermediateCertBucket = new SimpleCertificateBucket(CertificateUtils.getCertificates((String)"intermediatecert", (String[])new String[0]));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                throw new ServletException("OncePerRequestFilter just supports HTTP requests");
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String encodedTppCert = httpRequest.getHeader("tpp-certificate");
            CertificateValidatorFactory validatorFactory = new CertificateValidatorFactory(this.blockedCertBucket, this.rootCertBucket, this.intermediateCertBucket);
            try {
                validatorFactory.validate(encodedTppCert);
                TppCertificateData tppCertData = CertificateExtractorUtil.extract((String)encodedTppCert);
                request.setAttribute("tppCertData", (Object)tppCertData);
                chain.doFilter(request, response);
            }
            catch (CertificateException | CertificateValidationException e) {
                log.debug(e.getMessage());
                ((HttpServletResponse)response).sendError(401, e.getMessage());
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

