/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.aspect;

import de.adorsys.aspsp.xs2a.domain.Links;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReport;
import de.adorsys.aspsp.xs2a.web.AccountController;
import de.adorsys.aspsp.xs2a.web.aspect.AbstractLinkAspect;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Aspect
@Component
public class AccountAspect
extends AbstractLinkAspect<AccountController> {
    private static final Logger log = LoggerFactory.getLogger(AccountAspect.class);

    @AfterReturning(pointcut="execution(* de.adorsys.aspsp.xs2a.web.AccountController.readAccountDetails(..)) && args(consentId, accountId, withBalance, ..)", returning="result")
    public ResponseEntity<AccountDetails> invokeReadAccountDetailsAspect(ResponseEntity<AccountDetails> result, String consentId, String accountId, boolean withBalance) {
        if (!this.hasError(result)) {
            AccountDetails body = (AccountDetails)result.getBody();
            body.setLinks(this.buildLinksForAccountDetails(body, withBalance));
        }
        return new ResponseEntity(result.getBody(), (MultiValueMap)result.getHeaders(), result.getStatusCode());
    }

    @AfterReturning(pointcut="execution(* de.adorsys.aspsp.xs2a.web.AccountController.getAccounts(..)) && args(consentId, withBalance, ..)", returning="result")
    public ResponseEntity<Map<String, List<AccountDetails>>> invokeGetAccountsAspect(ResponseEntity<Map<String, List<AccountDetails>>> result, String consentId, boolean withBalance) {
        if (!this.hasError(result)) {
            Map body = (Map)result.getBody();
            this.setLinksToAccountsMap(body, withBalance);
        }
        return new ResponseEntity(result.getBody(), (MultiValueMap)result.getHeaders(), result.getStatusCode());
    }

    @AfterReturning(pointcut="execution(* de.adorsys.aspsp.xs2a.web.AccountController.getTransactions(..)) && args(accountId,..)", returning="result")
    public ResponseEntity<AccountReport> invokeGetTransactionsAspect(ResponseEntity<AccountReport> result, String accountId) {
        if (!this.hasError(result)) {
            AccountReport body = (AccountReport)result.getBody();
            body.setLinks(this.buildLinksForAccountReport(body, accountId));
        }
        return new ResponseEntity(result.getBody(), (MultiValueMap)result.getHeaders(), result.getStatusCode());
    }

    private Links buildLinksForAccountDetails(AccountDetails accountDetails, boolean withBalance) {
        Class controller = this.getController();
        Links links = new Links();
        if (withBalance) {
            links.setViewBalances(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(controller).slash((Object)accountDetails.getId())).slash((Object)"balances")).toString());
        }
        links.setViewTransactions(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(controller).slash((Object)accountDetails.getId())).slash((Object)"transactions")).toString());
        return links;
    }

    private Links buildLinksForAccountReport(AccountReport accountReport, String accountId) {
        Class controller = this.getController();
        Links links = new Links();
        links.setViewAccount(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(controller).slash((Object)accountId)).toString());
        Optional<String> optionalAccount = this.jsonConverter.toJson(accountReport);
        String jsonReport = optionalAccount.orElse("");
        if (jsonReport.length() > this.maxNumberOfCharInTransactionJson) {
            links.setDownload(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(controller).slash((Object)accountId)).slash((Object)"transactions/download")).toString());
        }
        return links;
    }

    private Map<String, List<AccountDetails>> setLinksToAccountsMap(Map<String, List<AccountDetails>> map, boolean withBalance) {
        map.entrySet().forEach(list -> this.updateAccountLinks((List)list.getValue(), withBalance));
        return map;
    }

    private List<AccountDetails> updateAccountLinks(List<AccountDetails> accountDetailsList, boolean withBalance) {
        return accountDetailsList.stream().map(acc -> this.setLinksToAccount((AccountDetails)acc, withBalance)).collect(Collectors.toList());
    }

    private AccountDetails setLinksToAccount(AccountDetails accountDetails, boolean withBalance) {
        accountDetails.setLinks(this.buildLinksForAccountDetails(accountDetails, withBalance));
        return accountDetails;
    }
}

