/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/payments/{payment-product}"})
@Api(value="api/v1/payments/{payment-product}", tags={"PISP, Payments"}, description="Provides access to the PIS")
public class PaymentInitiationController {
    private static final Logger log = LoggerFactory.getLogger(PaymentInitiationController.class);
    private final ResponseMapper responseMapper;
    private final PaymentService paymentService;

    @ApiOperation(value="Initialises a new payment ", notes="debtor account, creditor accout, creditor name, remittance information unstructured", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="psu-ip-address", value="192.168.8.78", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-id", value="12312324", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-id-type", value="Type of the PSU-ID", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-corporate-id", value="Might be mandated in the ASPSP\u2019s documentation", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-corporate-id-type", value="Might be mandated in the ASPSP\u2019s documentation", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-consent-id", value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-agent", value="The forwarded Agent header field of the http request between PSU and TPP.", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="psu-geo-location", value="GEO:52.506931,13.1445588", required=false, dataType="Geo Location", paramType="header"), @ApiImplicitParam(name="tpp-redirect-uri", value="Uri of TPP", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="timestamp", value="Sun, 06 Aug 2017 15:02:37 GMT", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="digest of the payload request", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="A signature of the request by TPP", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<PaymentInitialisationResponse> createPaymentInitiation(@ApiParam(name="payment-product", value="The addressed payment product endpoint for bulk payments e.g. for a bulk SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.") @RequestParam(name="tppRedirectPreferred", required=false) boolean tppRedirectPreferred, @RequestBody SinglePayments singlePayment) {
        return this.responseMapper.created(this.paymentService.createPaymentInitiation(singlePayment, paymentProduct, tppRedirectPreferred));
    }

    @ApiOperation(value="Get information  about the status of a payment initialisation ", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionStatus.class), @ApiResponse(code=404, message="Not found")})
    @GetMapping(path={"/{paymentId}/status"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="timestamp", value="Sun, 06 Aug 2017 15:02:37 GMT", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="digest of the payload request", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<TransactionStatus> getPaymentInitiationStatusById(@ApiParam(name="payment-product", value="The addressed payment product endpoint for bulk payments e.g. for a bulk SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="paymentId", value="529e0507-7539-4a65-9b74-bdf87061e99b") @PathVariable(value="paymentId") String paymentId) {
        return this.responseMapper.ok(this.paymentService.getPaymentStatusById(paymentId, paymentProduct));
    }

    @ConstructorProperties(value={"responseMapper", "paymentService"})
    public PaymentInitiationController(ResponseMapper responseMapper, PaymentService paymentService) {
        this.responseMapper = responseMapper;
        this.paymentService = paymentService;
    }
}

