/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.aspsp.xs2a.service.FundsConfirmationService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/funds-confirmations"})
@Api(value="api/v1/funds-confirmations", tags={"PIISP, Funds confirmation"}, description="Provides access to the funds confirmation")
public class FundsConfirmationController {
    private final FundsConfirmationService fundsConfirmationService;
    private final ResponseMapper responseMapper;

    @PostMapping
    @ApiOperation(value="Create a confirmation of funds request ", notes="debtor account, creditor account, creditor name, remittance information unstructured", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="return true or false"), @ApiResponse(code=400, message="Bad request")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="timestamp", value="Sun, 06 Aug 2017 15:02:37 GMT", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="digest of the payload request", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<FundsConfirmationResponse> fundConfirmation(@RequestBody FundsConfirmationRequest request) {
        return this.responseMapper.ok(this.fundsConfirmationService.fundsConfirmation(request));
    }

    @ConstructorProperties(value={"fundsConfirmationService", "responseMapper"})
    public FundsConfirmationController(FundsConfirmationService fundsConfirmationService, ResponseMapper responseMapper) {
        this.fundsConfirmationService = fundsConfirmationService;
        this.responseMapper = responseMapper;
    }
}

