/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/bulk-payments/{payment-product}"})
@Api(value="api/v1/consents", tags={"PISP, Bulk payment initiation"}, description="Payment Initiation for Bulk Payments and Multiple Payments")
public class BulkPaymentInitiationController {
    private final ResponseMapper responseMapper;
    private final PaymentService paymentService;

    @ApiOperation(value="Creates a bulk payment initiation request at the ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="transactions_status received, a list of hyperlinks to be recognized by the Tpp."), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="psu-ip-address", value="192.168.0.26", required=true, paramType="header"), @ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="x-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="timestamp", value="Sun, 06 Aug 2017 15:02:37 GMT", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="digest", value="digest of the payload request", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-signature-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<List<PaymentInitialisationResponse>> createBulkPaymentInitiation(@ApiParam(name="payment-product", value="The addressed payment product endpoint for bulk payments e.g. for a bulk SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.") @RequestParam(name="tppRedirectPreferred", required=false) boolean tppRedirectPreferred, @RequestBody List<SinglePayments> payments) {
        return this.responseMapper.created(this.paymentService.createBulkPayments(payments, paymentProduct, tppRedirectPreferred));
    }

    @ConstructorProperties(value={"responseMapper", "paymentService"})
    public BulkPaymentInitiationController(ResponseMapper responseMapper, PaymentService paymentService) {
        this.responseMapper = responseMapper;
        this.paymentService = paymentService;
    }
}

