/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.payment;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.consent.pis.PisConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedirectScaPaymentService
implements ScaPaymentService {
    @Autowired
    private PisConsentService pisConsentService;
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private PaymentSpi paymentSpi;

    @Override
    public Optional<PaymentInitialisationResponse> createPeriodicPayment(PeriodicPayment periodicPayment) {
        return this.createPeriodicPaymentAndGetResponse(periodicPayment).map(resp -> this.createConsentForPeriodicPaymentAndExtendPaymentResponse(periodicPayment, (PaymentInitialisationResponse)resp));
    }

    private Optional<PaymentInitialisationResponse> createPeriodicPaymentAndGetResponse(PeriodicPayment periodicPayment) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(periodicPayment);
        return this.paymentMapper.mapToPaymentInitializationResponse(this.paymentSpi.initiatePeriodicPayment(spiPeriodicPayment));
    }

    private PaymentInitialisationResponse createConsentForPeriodicPaymentAndExtendPaymentResponse(PeriodicPayment periodicPayment, PaymentInitialisationResponse response) {
        String pisConsentId = this.pisConsentService.createPisConsentForPeriodicPaymentAndGetId(periodicPayment);
        String iban = periodicPayment.getDebtorAccount().getIban();
        return StringUtils.isBlank((CharSequence)pisConsentId) ? null : this.extendPaymentResponseFields(response, iban, pisConsentId);
    }

    @Override
    public List<PaymentInitialisationResponse> createBulkPayment(List<SinglePayments> payments) {
        List<PaymentInitialisationResponse> responseList = this.createBulkPaymentAndGetResponse(payments);
        return CollectionUtils.isNotEmpty(responseList) ? this.createConsentForBulkPaymentAndExtendPaymentResponses(payments, responseList) : Collections.emptyList();
    }

    private List<PaymentInitialisationResponse> createBulkPaymentAndGetResponse(List<SinglePayments> payments) {
        List<SpiSinglePayments> spiPayments = this.paymentMapper.mapToSpiSinglePaymentList(payments);
        List spiPaymentInitiations = this.paymentSpi.createBulkPayments(spiPayments);
        List<PaymentInitialisationResponse> paymentResponses = spiPaymentInitiations.stream().map(this.paymentMapper::mapToPaymentInitializationResponse).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (PaymentInitialisationResponse resp : paymentResponses) {
            if (!StringUtils.isBlank((CharSequence)resp.getPaymentId()) && resp.getTransactionStatus() != TransactionStatus.RJCT) continue;
            resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
            resp.setTransactionStatus(TransactionStatus.RJCT);
        }
        return paymentResponses;
    }

    private List<PaymentInitialisationResponse> createConsentForBulkPaymentAndExtendPaymentResponses(List<SinglePayments> payments, List<PaymentInitialisationResponse> responseList) {
        String pisConsentId = this.pisConsentService.createPisConsentForBulkPaymentAndGetId(payments);
        return this.getDebtorIbanFromPayments(payments).map(iban -> responseList.stream().map(resp -> this.extendPaymentResponseFields((PaymentInitialisationResponse)resp, (String)iban, pisConsentId)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public Optional<PaymentInitialisationResponse> createSinglePayment(SinglePayments singlePayment) {
        return this.createSinglePaymentAndGetResponse(singlePayment).map(resp -> this.createConsentForSinglePaymentAndExtendPaymentResponse(singlePayment, (PaymentInitialisationResponse)resp));
    }

    private Optional<PaymentInitialisationResponse> createSinglePaymentAndGetResponse(SinglePayments singlePayment) {
        SpiSinglePayments spiSinglePayments = this.paymentMapper.mapToSpiSinglePayments(singlePayment);
        SpiPaymentInitialisationResponse spiPeriodicPaymentResp = this.paymentSpi.createPaymentInitiation(spiSinglePayments);
        return this.paymentMapper.mapToPaymentInitializationResponse(spiPeriodicPaymentResp);
    }

    private PaymentInitialisationResponse createConsentForSinglePaymentAndExtendPaymentResponse(SinglePayments singlePayment, PaymentInitialisationResponse response) {
        String pisConsentId = this.pisConsentService.createPisConsentForSinglePaymentAndGetId(singlePayment);
        String iban = singlePayment.getDebtorAccount().getIban();
        return StringUtils.isBlank((CharSequence)pisConsentId) ? null : this.extendPaymentResponseFields(response, iban, pisConsentId);
    }

    private PaymentInitialisationResponse extendPaymentResponseFields(PaymentInitialisationResponse response, String iban, String pisConsentId) {
        response.setPisConsentId(pisConsentId);
        response.setIban(iban);
        return response;
    }

    private Optional<String> getDebtorIbanFromPayments(List<SinglePayments> payments) {
        return Optional.ofNullable(payments.get(0).getDebtorAccount()).map(AccountReference::getIban);
    }
}

