/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.payment;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.AccountService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PaymentValidationService {
    private final AccountService accountService;

    public Optional<MessageErrorCode> validatePeriodicPayment(PeriodicPayment payment, String paymentProduct) {
        if (payment == null) {
            return Optional.of(MessageErrorCode.FORMAT_ERROR);
        }
        return payment.isValidDate() ? this.containsPaymentRelatedErrors(payment, paymentProduct) : Optional.of(MessageErrorCode.EXECUTION_DATE_INVALID);
    }

    public Optional<MessageErrorCode> validateSinglePayment(SinglePayments payment, String paymentProduct) {
        if (payment == null) {
            return Optional.of(MessageErrorCode.FORMAT_ERROR);
        }
        return payment.isValidDated() ? this.containsPaymentRelatedErrors(payment, paymentProduct) : Optional.of(MessageErrorCode.EXECUTION_DATE_INVALID);
    }

    private Optional<MessageErrorCode> containsPaymentRelatedErrors(SinglePayments payment, String paymentProduct) {
        if (!this.accountService.getAccountDetailsByAccountReference(payment.getDebtorAccount()).isPresent()) {
            return Optional.of(MessageErrorCode.RESOURCE_UNKNOWN_400);
        }
        if (this.accountService.isInvalidPaymentProductForPsu(payment.getDebtorAccount(), paymentProduct)) {
            return Optional.of(MessageErrorCode.PRODUCT_INVALID);
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"accountService"})
    public PaymentValidationService(AccountService accountService) {
        this.accountService = accountService;
    }
}

