/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.payment;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OauthScaPaymentService
implements ScaPaymentService {
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private PaymentSpi paymentSpi;

    @Override
    public Optional<PaymentInitialisationResponse> createPeriodicPayment(PeriodicPayment periodicPayment) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(periodicPayment);
        return this.paymentMapper.mapToPaymentInitializationResponse(this.paymentSpi.initiatePeriodicPayment(spiPeriodicPayment));
    }

    @Override
    public List<PaymentInitialisationResponse> createBulkPayment(List<SinglePayments> payments) {
        List<SpiSinglePayments> spiPayments = this.paymentMapper.mapToSpiSinglePaymentList(payments);
        List spiPaymentInitiations = this.paymentSpi.createBulkPayments(spiPayments);
        return spiPaymentInitiations.stream().map(this.paymentMapper::mapToPaymentInitializationResponse).filter(Optional::isPresent).map(Optional::get).peek(resp -> {
            if (StringUtils.isBlank((CharSequence)resp.getPaymentId()) || resp.getTransactionStatus() == TransactionStatus.RJCT) {
                resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
                resp.setTransactionStatus(TransactionStatus.RJCT);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Optional<PaymentInitialisationResponse> createSinglePayment(SinglePayments singlePayment) {
        SpiSinglePayments spiSinglePayments = this.paymentMapper.mapToSpiSinglePayments(singlePayment);
        SpiPaymentInitialisationResponse spiPeriodicPaymentResp = this.paymentSpi.createPaymentInitiation(spiSinglePayments);
        return this.paymentMapper.mapToPaymentInitializationResponse(spiPeriodicPaymentResp);
    }
}

