/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.consent.api.AccountInfo;
import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentRequest;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiAccountAccessType;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiCreateConsentRequest;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ConsentMapper {
    private final AccountMapper accountMapper;

    public AisConsentRequest mapToAisConsentRequest(CreateConsentReq req, String psuId, String tppId) {
        return Optional.ofNullable(req).map(r -> {
            AisConsentRequest request = new AisConsentRequest();
            request.setPsuId(psuId);
            request.setTppId(tppId);
            request.setFrequencyPerDay(r.getFrequencyPerDay());
            request.setAccess(this.mapToAisAccountAccessInfo(req.getAccess()));
            request.setValidUntil(r.getValidUntil());
            request.setRecurringIndicator(r.isRecurringIndicator());
            request.setCombinedServiceIndicator(r.isCombinedServiceIndicator());
            return request;
        }).orElse(null);
    }

    private AisAccountAccessInfo mapToAisAccountAccessInfo(AccountAccess access) {
        AisAccountAccessInfo accessInfo = new AisAccountAccessInfo();
        accessInfo.setAccounts(Optional.ofNullable(access.getAccounts()).map(this::mapToListAccountInfo).orElse(Collections.emptyList()));
        accessInfo.setBalances(Optional.ofNullable(access.getBalances()).map(this::mapToListAccountInfo).orElse(Collections.emptyList()));
        accessInfo.setTransactions(Optional.ofNullable(access.getTransactions()).map(this::mapToListAccountInfo).orElse(Collections.emptyList()));
        accessInfo.setAvailableAccounts((String)Optional.ofNullable(access.getAvailableAccounts()).map(Enum::name).orElse(null));
        accessInfo.setAllPsd2((String)Optional.ofNullable(access.getAllPsd2()).map(Enum::name).orElse(null));
        return accessInfo;
    }

    private List<AccountInfo> mapToListAccountInfo(List<AccountReference> refs) {
        return refs.stream().map(this::mapToAccountInfo).collect(Collectors.toList());
    }

    private AccountInfo mapToAccountInfo(AccountReference ref) {
        AccountInfo info = new AccountInfo();
        info.setIban(ref.getIban());
        info.setCurrency((String)Optional.ofNullable(ref.getCurrency()).map(Currency::getCurrencyCode).orElse(null));
        return info;
    }

    public TransactionStatus mapToTransactionStatus(SpiTransactionStatus spiTransactionStatus) {
        return Optional.ofNullable(spiTransactionStatus).map(ts -> TransactionStatus.valueOf(ts.name())).orElse(null);
    }

    public SpiCreateConsentRequest mapToSpiCreateConsentRequest(CreateConsentReq consentReq) {
        return Optional.ofNullable(consentReq).map(cr -> new SpiCreateConsentRequest(this.mapToSpiAccountAccess(cr.getAccess()), cr.isRecurringIndicator(), cr.getValidUntil(), cr.getFrequencyPerDay(), cr.isCombinedServiceIndicator())).orElse(null);
    }

    public AccountConsent mapToAccountConsent(SpiAccountConsent spiAccountConsent) {
        return Optional.ofNullable(spiAccountConsent).map(ac -> new AccountConsent(ac.getId(), this.mapToAccountAccess(ac.getAccess()), ac.isRecurringIndicator(), ac.getValidUntil(), ac.getFrequencyPerDay(), ac.getLastActionDate(), ConsentStatus.valueOf(ac.getSpiConsentStatus().name()), ac.isWithBalance(), ac.isTppRedirectPreferred())).orElse(null);
    }

    public Optional<ConsentStatus> mapToConsentStatus(SpiConsentStatus spiConsentStatus) {
        return Optional.ofNullable(spiConsentStatus).map(status -> ConsentStatus.valueOf(status.name()));
    }

    private AccountAccess mapToAccountAccess(SpiAccountAccess access) {
        return Optional.ofNullable(access).map(aa -> new AccountAccess(this.accountMapper.mapToAccountReferences(aa.getAccounts()), this.accountMapper.mapToAccountReferences(aa.getBalances()), this.accountMapper.mapToAccountReferences(aa.getTransactions()), this.mapToAccountAccessType(aa.getAvailableAccounts()), this.mapToAccountAccessType(aa.getAllPsd2()))).orElse(null);
    }

    private AccountAccessType mapToAccountAccessType(SpiAccountAccessType accessType) {
        return Optional.ofNullable(accessType).map(at -> AccountAccessType.valueOf(at.name())).orElse(null);
    }

    private SpiAccountAccess mapToSpiAccountAccess(AccountAccess access) {
        return Optional.ofNullable(access).map(aa -> {
            SpiAccountAccess spiAccountAccess = new SpiAccountAccess();
            spiAccountAccess.setAccounts(this.accountMapper.mapToSpiAccountReferences(aa.getAccounts()));
            spiAccountAccess.setBalances(this.accountMapper.mapToSpiAccountReferences(aa.getBalances()));
            spiAccountAccess.setTransactions(this.accountMapper.mapToSpiAccountReferences(aa.getTransactions()));
            spiAccountAccess.setAvailableAccounts(this.mapToSpiAccountAccessType(aa.getAvailableAccounts()));
            spiAccountAccess.setAllPsd2(this.mapToSpiAccountAccessType(aa.getAllPsd2()));
            return spiAccountAccess;
        }).orElse(null);
    }

    private SpiAccountAccessType mapToSpiAccountAccessType(AccountAccessType accessType) {
        return Optional.ofNullable(accessType).map(at -> SpiAccountAccessType.valueOf((String)at.name())).orElse(null);
    }

    public ActionStatus mapActionStatusError(MessageErrorCode error, boolean withBalance, TypeAccess access) {
        ActionStatus actionStatus = ActionStatus.FAILURE_ACCOUNT;
        if (error == MessageErrorCode.ACCESS_EXCEEDED) {
            actionStatus = ActionStatus.CONSENT_LIMIT_EXCEEDED;
        }
        if (error == MessageErrorCode.CONSENT_EXPIRED) {
            actionStatus = ActionStatus.CONSENT_INVALID_STATUS;
        }
        if (error == MessageErrorCode.CONSENT_UNKNOWN_400) {
            actionStatus = ActionStatus.CONSENT_NOT_FOUND;
        }
        if (error == MessageErrorCode.CONSENT_INVALID) {
            if (access == TypeAccess.TRANSACTION) {
                actionStatus = ActionStatus.FAILURE_TRANSACTION;
            }
            if (access == TypeAccess.BALANCE || withBalance) {
                actionStatus = ActionStatus.FAILURE_BALANCE;
            }
        }
        return actionStatus;
    }

    @ConstructorProperties(value={"accountMapper"})
    public ConsentMapper(AccountMapper accountMapper) {
        this.accountMapper = accountMapper;
    }
}

