/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisAddress;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPeriodicPayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisRemittance;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisSinglePayment;
import de.adorsys.aspsp.xs2a.domain.address.Address;
import de.adorsys.aspsp.xs2a.domain.code.BICFI;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.Remittance;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CmsPisMapper {
    private final AccountMapper accountMapper;
    private final PaymentMapper paymentMapper;

    public PisSinglePayment mapToPisSinglePayment(SinglePayments paymentInitiationRequest) {
        return Optional.ofNullable(paymentInitiationRequest).map(payReq -> {
            PisSinglePayment pisSinglePayment = new PisSinglePayment();
            pisSinglePayment.setEndToEndIdentification(payReq.getEndToEndIdentification());
            pisSinglePayment.setDebtorAccount(this.accountMapper.mapToPisAccountReference(payReq.getDebtorAccount()));
            pisSinglePayment.setUltimateDebtor(payReq.getUltimateDebtor());
            pisSinglePayment.setInstructedAmount(this.accountMapper.mapToPisAmount(payReq.getInstructedAmount()));
            pisSinglePayment.setCreditorAccount(this.accountMapper.mapToPisAccountReference(payReq.getCreditorAccount()));
            pisSinglePayment.setCreditorAgent(Optional.ofNullable(payReq.getCreditorAgent()).map(BICFI::getCode).orElse(""));
            pisSinglePayment.setCreditorName(payReq.getCreditorName());
            pisSinglePayment.setCreditorAddress(this.mapToPisAddress(payReq.getCreditorAddress()));
            pisSinglePayment.setUltimateCreditor(payReq.getUltimateCreditor());
            pisSinglePayment.setPurposeCode(Optional.ofNullable(payReq.getPurposeCode()).map(PurposeCode::getCode).orElse(""));
            pisSinglePayment.setRemittanceInformationUnstructured(payReq.getRemittanceInformationUnstructured());
            pisSinglePayment.setRemittanceInformationStructured(this.mapToPisRemittance(payReq.getRemittanceInformationStructured()));
            pisSinglePayment.setRequestedExecutionDate(payReq.getRequestedExecutionDate());
            pisSinglePayment.setRequestedExecutionTime(payReq.getRequestedExecutionTime());
            return pisSinglePayment;
        }).orElse(null);
    }

    public List<PisSinglePayment> mapToPisSinglePaymentList(List<SinglePayments> singlePayments) {
        return singlePayments.stream().map(this::mapToPisSinglePayment).collect(Collectors.toList());
    }

    public PisPeriodicPayment mapToPisPeriodicPayment(PeriodicPayment periodicPayment) {
        return Optional.ofNullable(periodicPayment).map(pp -> {
            PisPeriodicPayment pisPeriodicPayment = new PisPeriodicPayment();
            pisPeriodicPayment.setEndToEndIdentification(pp.getEndToEndIdentification());
            pisPeriodicPayment.setDebtorAccount(this.accountMapper.mapToPisAccountReference(pp.getDebtorAccount()));
            pisPeriodicPayment.setUltimateDebtor(pp.getUltimateDebtor());
            pisPeriodicPayment.setInstructedAmount(this.accountMapper.mapToPisAmount(pp.getInstructedAmount()));
            pisPeriodicPayment.setCreditorAccount(this.accountMapper.mapToPisAccountReference(pp.getCreditorAccount()));
            pisPeriodicPayment.setCreditorAgent(this.paymentMapper.getCreditorAgentCode((PeriodicPayment)pp));
            pisPeriodicPayment.setCreditorName(pp.getCreditorName());
            pisPeriodicPayment.setCreditorAddress(this.mapToPisAddress(pp.getCreditorAddress()));
            pisPeriodicPayment.setUltimateCreditor(pp.getUltimateCreditor());
            pisPeriodicPayment.setPurposeCode(this.paymentMapper.getPurposeCode((PeriodicPayment)pp));
            pisPeriodicPayment.setRemittanceInformationUnstructured(pp.getRemittanceInformationUnstructured());
            pisPeriodicPayment.setRemittanceInformationStructured(this.mapToPisRemittance(pp.getRemittanceInformationStructured()));
            pisPeriodicPayment.setRequestedExecutionDate(pp.getRequestedExecutionDate());
            pisPeriodicPayment.setRequestedExecutionTime(pp.getRequestedExecutionTime());
            pisPeriodicPayment.setStartDate(pp.getStartDate());
            pisPeriodicPayment.setExecutionRule(pp.getExecutionRule());
            pisPeriodicPayment.setEndDate(pp.getEndDate());
            pisPeriodicPayment.setFrequency(this.paymentMapper.getFrequency((PeriodicPayment)pp));
            pisPeriodicPayment.setDayOfExecution(pp.getDayOfExecution());
            return pisPeriodicPayment;
        }).orElse(null);
    }

    private PisAddress mapToPisAddress(Address address) {
        return Optional.ofNullable(address).map(a -> new PisAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), a.getCountry().getCode())).orElse(null);
    }

    private PisRemittance mapToPisRemittance(Remittance remittance) {
        return Optional.ofNullable(remittance).map(r -> new PisRemittance(r.getReference(), r.getReferenceType(), r.getReferenceIssuer())).orElse(null);
    }

    @ConstructorProperties(value={"accountMapper", "paymentMapper"})
    public CmsPisMapper(AccountMapper accountMapper, PaymentMapper paymentMapper) {
        this.accountMapper = accountMapper;
        this.paymentMapper = paymentMapper;
    }
}

