/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.consent.ais;

import de.adorsys.aspsp.xs2a.config.rest.consent.AisConsentRemoteUrls;
import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.service.mapper.ConsentMapper;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AisConsentService {
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final AisConsentRemoteUrls remoteAisConsentUrls;
    private final ConsentMapper consentMapper;

    public String createConsent(CreateConsentReq request, String psuId, String tppId) {
        return (String)this.consentRestTemplate.postForEntity(this.remoteAisConsentUrls.createAisConsent(), (Object)this.consentMapper.mapToAisConsentRequest(request, psuId, tppId), String.class, new Object[0]).getBody();
    }

    public SpiAccountConsent getAccountConsentById(String consentId) {
        return (SpiAccountConsent)this.consentRestTemplate.getForEntity(this.remoteAisConsentUrls.getAisConsentById(), SpiAccountConsent.class, new Object[]{consentId}).getBody();
    }

    public SpiConsentStatus getAccountConsentStatusById(String consentId) {
        return (SpiConsentStatus)this.consentRestTemplate.getForEntity(this.remoteAisConsentUrls.getAisConsentStatusById(), SpiConsentStatus.class, new Object[]{consentId}).getBody();
    }

    public void revokeConsent(String consentId) {
        this.consentRestTemplate.put(this.remoteAisConsentUrls.updateAisConsentStatus(), null, new Object[]{consentId, SpiConsentStatus.REVOKED_BY_PSU});
    }

    public void consentActionLog(String tppId, String consentId, boolean withBalance, TypeAccess access, ResponseObject response) {
        ActionStatus status = response.hasError() ? this.consentMapper.mapActionStatusError(response.getError().getTppMessage().getCode(), withBalance, access) : ActionStatus.SUCCESS;
        this.consentRestTemplate.postForEntity(this.remoteAisConsentUrls.consentActionLog(), (Object)new ConsentActionRequest(tppId, consentId, status), Void.class, new Object[0]);
    }

    @ConstructorProperties(value={"consentRestTemplate", "remoteAisConsentUrls", "consentMapper"})
    public AisConsentService(RestTemplate consentRestTemplate, AisConsentRemoteUrls remoteAisConsentUrls, ConsentMapper consentMapper) {
        this.consentRestTemplate = consentRestTemplate;
        this.remoteAisConsentUrls = remoteAisConsentUrls;
        this.consentMapper = consentMapper;
    }
}

