/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentType;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.service.payment.PaymentValidationService;
import de.adorsys.aspsp.xs2a.service.payment.ReadPayment;
import de.adorsys.aspsp.xs2a.service.payment.ReadPaymentFactory;
import de.adorsys.aspsp.xs2a.service.payment.ScaPaymentService;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private final PaymentSpi paymentSpi;
    private final PaymentMapper paymentMapper;
    private final ScaPaymentService scaPaymentService;
    private final PaymentValidationService paymentValidationService;
    private final ReadPaymentFactory readPaymentFactory;

    public ResponseObject<TransactionStatus> getPaymentStatusById(String paymentId, String paymentProduct) {
        TransactionStatus transactionStatus = this.paymentMapper.mapToTransactionStatus(this.paymentSpi.getPaymentStatusById(paymentId, paymentProduct));
        return ResponseObject.builder().body(transactionStatus).build();
    }

    public ResponseObject<PaymentInitialisationResponse> initiatePeriodicPayment(PeriodicPayment periodicPayment, String paymentProduct, boolean tppRedirectPreferred) {
        Optional<MessageErrorCode> messageErrorCode = this.paymentValidationService.validatePeriodicPayment(periodicPayment, paymentProduct);
        if (messageErrorCode.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, messageErrorCode.get()))).build();
        }
        return this.scaPaymentService.createPeriodicPayment(periodicPayment).map(resp -> ResponseObject.builder().body((PaymentInitialisationResponse)resp).build()).orElse(ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build());
    }

    public ResponseObject<List<PaymentInitialisationResponse>> createBulkPayments(List<SinglePayments> payments, String paymentProduct, boolean tppRedirectPreferred) {
        List<PaymentInitialisationResponse> paymentResponses;
        if (CollectionUtils.isEmpty(payments)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
        }
        ArrayList<SinglePayments> validPayments = new ArrayList<SinglePayments>();
        ArrayList invalidPayments = new ArrayList();
        for (SinglePayments s : payments) {
            Optional<MessageErrorCode> messageErrorCode = this.paymentValidationService.validateSinglePayment(s, paymentProduct);
            if (messageErrorCode.isPresent()) {
                this.paymentMapper.mapToPaymentInitResponseFailedPayment(s == null ? new SinglePayments() : s, messageErrorCode.get(), tppRedirectPreferred).map(invalidPayments::add);
                continue;
            }
            validPayments.add(s);
        }
        if (CollectionUtils.isNotEmpty(validPayments) && CollectionUtils.isNotEmpty(paymentResponses = this.scaPaymentService.createBulkPayment(validPayments)) && paymentResponses.stream().anyMatch(pr -> pr.getTransactionStatus() != TransactionStatus.RJCT)) {
            paymentResponses.addAll(invalidPayments);
            return ResponseObject.builder().body(paymentResponses).build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build();
    }

    public ResponseObject<PaymentInitialisationResponse> createPaymentInitiation(SinglePayments singlePayment, String paymentProduct, boolean tppRedirectPreferred) {
        Optional<MessageErrorCode> messageErrorCode = this.paymentValidationService.validateSinglePayment(singlePayment, paymentProduct);
        if (messageErrorCode.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, messageErrorCode.get()))).build();
        }
        return this.scaPaymentService.createSinglePayment(singlePayment).map(resp -> ResponseObject.builder().body((PaymentInitialisationResponse)resp).build()).orElse(ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build());
    }

    public ResponseObject<Object> getPaymentById(PaymentType paymentType, String paymentProduct, String paymentId) {
        ReadPayment service = this.readPaymentFactory.getService(paymentType.getValue());
        Optional payment = Optional.ofNullable(service.getPayment(paymentProduct, paymentId));
        return payment.isPresent() ? ResponseObject.builder().body(payment.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_403))).build();
    }

    @ConstructorProperties(value={"paymentSpi", "paymentMapper", "scaPaymentService", "paymentValidationService", "readPaymentFactory"})
    public PaymentService(PaymentSpi paymentSpi, PaymentMapper paymentMapper, ScaPaymentService scaPaymentService, PaymentValidationService paymentValidationService, ReadPaymentFactory readPaymentFactory) {
        this.paymentSpi = paymentSpi;
        this.paymentMapper = paymentMapper;
        this.scaPaymentService = scaPaymentService;
        this.paymentValidationService = paymentValidationService;
        this.readPaymentFactory = readPaymentFactory;
    }
}

