/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Balances;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.SingleBalance;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.aspsp.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.aspsp.xs2a.service.AccountService;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FundsConfirmationService {
    private final AccountService accountService;

    public ResponseObject<FundsConfirmationResponse> fundsConfirmation(FundsConfirmationRequest request) {
        Boolean fundsAvailable = Optional.ofNullable(request).map(req -> this.isFundsAvailable(req.getPsuAccount(), req.getInstructedAmount())).orElse(false);
        return ResponseObject.builder().body(new FundsConfirmationResponse(fundsAvailable)).build();
    }

    private boolean isFundsAvailable(AccountReference accountReference, Amount requiredAmount) {
        List<Balances> balances = this.getAccountBalancesByAccountReference(accountReference);
        return balances.stream().findFirst().map(Balances::getInterimAvailable).map(SingleBalance::getAmount).map(am -> this.isRequiredAmountEnough(requiredAmount, (Amount)am)).orElse(false);
    }

    private boolean isRequiredAmountEnough(Amount requiredAmount, Amount availableAmount) {
        return this.convertToBigDecimal(availableAmount.getContent()).compareTo(this.convertToBigDecimal(requiredAmount.getContent())) >= 0 && availableAmount.getCurrency() == requiredAmount.getCurrency();
    }

    private BigDecimal convertToBigDecimal(String content) {
        return Optional.ofNullable(content).map(BigDecimal::new).orElse(BigDecimal.ZERO);
    }

    private List<Balances> getAccountBalancesByAccountReference(AccountReference reference) {
        return Optional.ofNullable(reference).map(this.accountService::getAccountDetailsByAccountReference).filter(Optional::isPresent).map(Optional::get).map(AccountDetails::getBalances).orElse(Collections.emptyList());
    }

    @ConstructorProperties(value={"accountService"})
    public FundsConfirmationService(AccountService accountService) {
        this.accountService = accountService;
    }
}

