/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentResp;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.consent.ais.AisConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.service.mapper.ConsentMapper;
import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final ConsentMapper consentMapper;
    private final AisConsentService aisConsentService;
    private final AccountSpi accountSpi;
    private final AccountMapper accountMapper;

    public ResponseObject<CreateConsentResp> createAccountConsentsWithResponse(CreateConsentReq request, boolean withBalance, boolean tppRedirectPreferred, String psuId) {
        String tppId = "This is a test TppId";
        CreateConsentReq checkedRequest = new CreateConsentReq();
        if (this.isNotEmptyAccess(request.getAccess()).booleanValue() && request.getValidUntil().isAfter(LocalDate.now())) {
            if (this.isAllAccountsRequest(request) && psuId != null) {
                checkedRequest.setAccess(this.getAccessByPsuId(AccountAccessType.ALL_ACCOUNTS == request.getAccess().getAllPsd2(), psuId));
            } else {
                checkedRequest.setAccess(this.getAccessByRequestedAccess(request.getAccess()));
            }
            checkedRequest.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
            checkedRequest.setRecurringIndicator(request.isRecurringIndicator());
            checkedRequest.setFrequencyPerDay(request.getFrequencyPerDay());
            checkedRequest.setValidUntil(request.getValidUntil());
        }
        String consentId = this.isNotEmptyAccess(checkedRequest.getAccess()) != false ? this.aisConsentService.createConsent(checkedRequest, psuId, tppId) : null;
        return !StringUtils.isBlank(consentId) ? ResponseObject.builder().body(new CreateConsentResp(ConsentStatus.RECEIVED, consentId, null, null, null)).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_400))).build();
    }

    public ResponseObject<ConsentStatus> getAccountConsentsStatusById(String consentId) {
        return this.consentMapper.mapToConsentStatus(this.aisConsentService.getAccountConsentStatusById(consentId)).map(status -> ResponseObject.builder().body((ConsentStatus)((Object)status)).build()).orElse(ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build());
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        if (this.aisConsentService.getAccountConsentById(consentId) != null) {
            this.aisConsentService.revokeConsent(consentId);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        AccountConsent consent = this.consentMapper.mapToAccountConsent(this.aisConsentService.getAccountConsentById(consentId));
        return consent == null ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build() : ResponseObject.builder().body(consent).build();
    }

    ResponseObject<AccountAccess> getValidatedConsent(String consentId) {
        AccountConsent consent = this.consentMapper.mapToAccountConsent(this.aisConsentService.getAccountConsentById(consentId));
        if (consent == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
        }
        if (!consent.isValidStatus()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_EXPIRED))).build();
        }
        if (!consent.isValidFrequency()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.ACCESS_EXCEEDED))).build();
        }
        return ResponseObject.builder().body(consent.getAccess()).build();
    }

    boolean isValidAccountByAccess(String iban, Currency currency, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getIban().equals(iban) && a.getCurrency() == currency);
    }

    private Set<String> getIbansFromAccountReference(List<AccountReference> references) {
        return Optional.ofNullable(references).map(list -> list.stream().map(AccountReference::getIban).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private Boolean isNotEmptyAccess(AccountAccess access) {
        return Optional.ofNullable(access).map(AccountAccess::isNotEmpty).orElse(false);
    }

    private AccountAccess getAccessByRequestedAccess(AccountAccess requestedAccess) {
        List<AccountReference> aspspReferences = this.accountMapper.mapToAccountReferencesFromDetails(this.accountSpi.readAccountDetailsByIbans(this.getIbansFromAccess(requestedAccess)));
        List<AccountReference> balances = this.getFilteredReferencesByAccessReferences(requestedAccess.getBalances(), aspspReferences);
        List<AccountReference> transaction = this.getRequestedReferences(requestedAccess.getTransactions(), aspspReferences);
        List<AccountReference> accounts = this.getRequestedReferences(requestedAccess.getAccounts(), aspspReferences);
        return new AccountAccess(this.getAccountsForAccess(balances, transaction, accounts), balances, transaction, null, null);
    }

    private List<AccountReference> getFilteredReferencesByAccessReferences(List<AccountReference> requestedReferences, List<AccountReference> refs) {
        return Optional.ofNullable(requestedReferences).map(reqRefs -> this.getRequestedReferences((List<AccountReference>)reqRefs, refs)).orElse(Collections.emptyList());
    }

    private List<AccountReference> getAccountsForAccess(List<AccountReference> balances, List<AccountReference> transactions, List<AccountReference> accounts) {
        accounts.removeAll(balances);
        accounts.addAll(balances);
        accounts.removeAll(transactions);
        accounts.addAll(transactions);
        return accounts;
    }

    private List<AccountReference> getRequestedReferences(List<AccountReference> requestedRefs, List<AccountReference> refs) {
        return Optional.ofNullable(requestedRefs).map(rr -> rr.stream().filter(r -> this.isContainedRefInRefsList((AccountReference)r, refs)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean isContainedRefInRefsList(AccountReference referenceMatched, List<AccountReference> references) {
        return references.stream().anyMatch(r -> r.matches(referenceMatched));
    }

    private AccountAccess getAccessByPsuId(boolean isAllPSD2, String psuId) {
        List<AccountReference> refs = this.accountMapper.mapToAccountReferencesFromDetails(this.accountSpi.readAccountsByPsuId(psuId));
        if (CollectionUtils.isNotEmpty(refs)) {
            return isAllPSD2 ? new AccountAccess(refs, refs, refs, null, AccountAccessType.ALL_ACCOUNTS) : new AccountAccess(refs, Collections.emptyList(), Collections.emptyList(), AccountAccessType.ALL_ACCOUNTS, null);
        }
        return new AccountAccess(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null);
    }

    private boolean isAllAccountsRequest(CreateConsentReq request) {
        return Optional.ofNullable(request.getAccess()).filter(a -> AccountAccessType.ALL_ACCOUNTS == a.getAllPsd2() || AccountAccessType.ALL_ACCOUNTS == a.getAvailableAccounts()).isPresent();
    }

    private Set<String> getIbansFromAccess(AccountAccess access) {
        return Stream.of(this.getIbansFromAccountReference(access.getAccounts()), this.getIbansFromAccountReference(access.getBalances()), this.getIbansFromAccountReference(access.getTransactions())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @ConstructorProperties(value={"consentMapper", "aisConsentService", "accountSpi", "accountMapper"})
    public ConsentService(ConsentMapper consentMapper, AisConsentService aisConsentService, AccountSpi accountSpi, AccountMapper accountMapper) {
        this.consentMapper = consentMapper;
        this.aisConsentService = aisConsentService;
        this.accountSpi = accountSpi;
        this.accountMapper = accountMapper;
    }
}

