/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.config.rest.profile.AspspProfileRemoteUrls;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.domain.ScaApproach;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentProduct;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AspspProfileService {
    @Qualifier(value="aspspProfileRestTemplate")
    private final RestTemplate aspspProfileRestTemplate;
    private final AspspProfileRemoteUrls aspspProfileRemoteUrls;

    public List<PaymentProduct> getAvailablePaymentProducts() {
        return Optional.ofNullable(this.readAvailablePaymentProducts()).map(list -> list.stream().map(PaymentProduct::getByCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<PisPaymentType> getAvailablePaymentTypes() {
        return Optional.ofNullable(this.readAvailablePaymentTypes()).map(list -> list.stream().map(PisPaymentType::getByValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public boolean isRedirectMode() {
        ScaApproach scaApproach = this.readScaApproach();
        return scaApproach == ScaApproach.REDIRECT || scaApproach == ScaApproach.DECOUPLED;
    }

    public boolean isSupportedPaymentProduct(PaymentProduct product) {
        return this.getAvailablePaymentProducts().contains((Object)product);
    }

    private List<String> readAvailablePaymentProducts() {
        return (List)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getAvailablePaymentProducts(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[0]).getBody();
    }

    public ScaApproach readScaApproach() {
        return (ScaApproach)((Object)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getScaApproach(), HttpMethod.GET, null, ScaApproach.class, new Object[0]).getBody());
    }

    public Boolean getTppSignatureRequired() {
        return (Boolean)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getTppSignatureRequired(), HttpMethod.GET, null, Boolean.class, new Object[0]).getBody();
    }

    public String getPisRedirectUrlToAspsp() {
        return (String)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getPisRedirectUrlToAspsp(), HttpMethod.GET, null, String.class, new Object[0]).getBody();
    }

    public String getAisRedirectUrlToAspsp() {
        return (String)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getAisRedirectUrlToAspsp(), HttpMethod.GET, null, String.class, new Object[0]).getBody();
    }

    private List<String> readAvailablePaymentTypes() {
        return (List)this.aspspProfileRestTemplate.exchange(this.aspspProfileRemoteUrls.getAvailablePaymentTypes(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[0]).getBody();
    }

    @ConstructorProperties(value={"aspspProfileRestTemplate", "aspspProfileRemoteUrls"})
    public AspspProfileService(RestTemplate aspspProfileRestTemplate, AspspProfileRemoteUrls aspspProfileRemoteUrls) {
        this.aspspProfileRestTemplate = aspspProfileRestTemplate;
        this.aspspProfileRemoteUrls = aspspProfileRemoteUrls;
    }
}

