/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.address.Address;
import de.adorsys.aspsp.xs2a.domain.code.BICFI;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import de.adorsys.aspsp.xs2a.domain.pis.Remittance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Size;

@ApiModel(description="Payment Initialisation Request", value="SinglePayments")
public class SinglePayments {
    @ApiModelProperty(value="end to end authentication", example="RI-123456789")
    @Size(max=35)
    private @Size(max=35) String endToEndIdentification;
    @ApiModelProperty(value="debtor account", required=true)
    private AccountReference debtorAccount;
    @ApiModelProperty(value="ultimate debtor", example="Mueller")
    @Size(max=70)
    private @Size(max=70) String ultimateDebtor;
    @ApiModelProperty(value="instructed amount", required=true)
    private Amount instructedAmount;
    @ApiModelProperty(value="creditor account", required=true)
    private AccountReference creditorAccount;
    @ApiModelProperty(value="creditor agent")
    private BICFI creditorAgent;
    @ApiModelProperty(value="creditor name", required=true, example="Telekom")
    @Size(max=70)
    private @Size(max=70) String creditorName;
    @ApiModelProperty(value="creditor Address")
    private Address creditorAddress;
    @ApiModelProperty(value="ultimate creditor", example="Telekom")
    @Size(max=70)
    private @Size(max=70) String ultimateCreditor;
    @ApiModelProperty(value="purpose code")
    private PurposeCode purposeCode;
    @ApiModelProperty(value="remittance information unstructured", example="Ref. Number TELEKOM-1222")
    @Size(max=140)
    private @Size(max=140) String remittanceInformationUnstructured;
    @ApiModelProperty(value="remittance information structured")
    private Remittance remittanceInformationStructured;
    @ApiModelProperty(value="requested execution date", example="2017-01-01")
    @FutureOrPresent
    private LocalDate requestedExecutionDate;
    @ApiModelProperty(value="requested execution time", example="2017-10-25T15:30:35.035")
    @FutureOrPresent
    private LocalDateTime requestedExecutionTime;

    @JsonIgnore
    public boolean isValidDated() {
        return Optional.ofNullable(this.requestedExecutionDate).map(d -> d.isEqual(LocalDate.now()) || d.isAfter(LocalDate.now())).orElse(false) != false && Optional.ofNullable(this.requestedExecutionTime).map(d -> d.isAfter(LocalDate.now().atTime(0, 0))).orElse(false) != false;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public BICFI getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public Remittance getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(BICFI creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(Remittance remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinglePayments)) {
            return false;
        }
        SinglePayments other = (SinglePayments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Amount this$instructedAmount = this.getInstructedAmount();
        Amount other$instructedAmount = other.getInstructedAmount();
        if (this$instructedAmount == null ? other$instructedAmount != null : !((Object)this$instructedAmount).equals(other$instructedAmount)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !((Object)this$creditorAccount).equals(other$creditorAccount)) {
            return false;
        }
        BICFI this$creditorAgent = this.getCreditorAgent();
        BICFI other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !((Object)this$creditorAgent).equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        Address this$creditorAddress = this.getCreditorAddress();
        Address other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !((Object)this$creditorAddress).equals(other$creditorAddress)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        PurposeCode this$purposeCode = this.getPurposeCode();
        PurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !((Object)this$purposeCode).equals(other$purposeCode)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        Remittance this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        Remittance other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !((Object)this$remittanceInformationStructured).equals(other$remittanceInformationStructured)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        return !(this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinglePayments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Amount $instructedAmount = this.getInstructedAmount();
        result = result * 59 + ($instructedAmount == null ? 43 : ((Object)$instructedAmount).hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : ((Object)$creditorAccount).hashCode());
        BICFI $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : ((Object)$creditorAgent).hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        Address $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : ((Object)$creditorAddress).hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        PurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : ((Object)$purposeCode).hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        Remittance $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : ((Object)$remittanceInformationStructured).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        return result;
    }

    public String toString() {
        return "SinglePayments(endToEndIdentification=" + this.getEndToEndIdentification() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", instructedAmount=" + this.getInstructedAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ")";
    }
}

