/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PaymentType {
    SINGLE("payments"),
    BULK("bulk-payments"),
    PERIODIC("periodic-payments");

    private String value;
    private static final Map<String, PaymentType> container;

    @JsonCreator
    private PaymentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<PaymentType> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    static {
        container = new HashMap<String, PaymentType>();
        for (PaymentType type : PaymentType.values()) {
            container.put(type.getValue(), type);
        }
    }
}

