/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.aspsp.xs2a.domain.Links;
import de.adorsys.aspsp.xs2a.domain.consent.AuthenticationObject;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;

@ApiModel(description="Response for the create account information consent request in the Account service")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateConsentResp {
    @ApiModelProperty(value="Authentication status of the consent", required=true)
    private final ConsentStatus consentStatus;
    @ApiModelProperty(value="Identification of the consent resource as it is used in the API structure", required=false)
    private final String consentId;
    @ApiModelProperty(value="This data element might be contained, if SCA is required and if the PSU has a choice between different authentication methods. Depending on the risk management of the ASPSP this choice might be offered before or after the PSU has been identified with the first relevant factor, or if an access token is transported. If this data element is contained, then there is also an hyperlink of type 'selectAuthenticationMethods' contained in the response body.", required=false)
    private final AuthenticationObject[] scaMethods;
    @ApiModelProperty(value="A list of hyperlinks to be recognized by Tpp", required=true)
    @JsonProperty(value="_links")
    private final Links links;
    @ApiModelProperty(value="Text to be displayed to the PSU, e.g. in a Decoupled SCA Approach", required=false)
    private final String psuMessage;

    @ConstructorProperties(value={"consentStatus", "consentId", "scaMethods", "links", "psuMessage"})
    public CreateConsentResp(ConsentStatus consentStatus, String consentId, AuthenticationObject[] scaMethods, Links links, String psuMessage) {
        this.consentStatus = consentStatus;
        this.consentId = consentId;
        this.scaMethods = scaMethods;
        this.links = links;
        this.psuMessage = psuMessage;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public String getConsentId() {
        return this.consentId;
    }

    public AuthenticationObject[] getScaMethods() {
        return this.scaMethods;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getPsuMessage() {
        return this.psuMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConsentResp)) {
            return false;
        }
        CreateConsentResp other = (CreateConsentResp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !((Object)((Object)this$consentStatus)).equals((Object)other$consentStatus)) {
            return false;
        }
        String this$consentId = this.getConsentId();
        String other$consentId = other.getConsentId();
        if (this$consentId == null ? other$consentId != null : !this$consentId.equals(other$consentId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScaMethods(), other.getScaMethods())) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$psuMessage = this.getPsuMessage();
        String other$psuMessage = other.getPsuMessage();
        return !(this$psuMessage == null ? other$psuMessage != null : !this$psuMessage.equals(other$psuMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConsentResp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : ((Object)((Object)$consentStatus)).hashCode());
        String $consentId = this.getConsentId();
        result = result * 59 + ($consentId == null ? 43 : $consentId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getScaMethods());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $psuMessage = this.getPsuMessage();
        result = result * 59 + ($psuMessage == null ? 43 : $psuMessage.hashCode());
        return result;
    }

    public String toString() {
        return "CreateConsentResp(consentStatus=" + (Object)((Object)this.getConsentStatus()) + ", consentId=" + this.getConsentId() + ", scaMethods=" + Arrays.deepToString(this.getScaMethods()) + ", links=" + this.getLinks() + ", psuMessage=" + this.getPsuMessage() + ")";
    }
}

