/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;

@ApiModel(description="Request creates an account information consent resource at the ASPSP regarding access to accounts specified in this request")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateConsentReq {
    @ApiModelProperty(value="Requested access services.", required=true)
    @NotNull
    private AccountAccess access;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true)
    @NotNull
    private boolean recurringIndicator;
    @ApiModelProperty(value="This parameter is requesting a valid until date for the requested consent. The content is the local ASPSP date in ISODate Format", required=true, example="2017-10-30")
    @NotNull
    private LocalDate validUntil;
    @ApiModelProperty(value="This field indicates the requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    @NotNull
    private int frequencyPerDay;
    @ApiModelProperty(value="If 'true' indicates that a payment initiation service will be addressed in the same 'session'", required=true)
    @NotNull
    private boolean combinedServiceIndicator;

    public AccountAccess getAccess() {
        return this.access;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public void setAccess(AccountAccess access) {
        this.access = access;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConsentReq)) {
            return false;
        }
        CreateConsentReq other = (CreateConsentReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountAccess this$access = this.getAccess();
        AccountAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        return this.isCombinedServiceIndicator() == other.isCombinedServiceIndicator();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConsentReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CreateConsentReq(access=" + this.getAccess() + ", recurringIndicator=" + this.isRecurringIndicator() + ", validUntil=" + this.getValidUntil() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ")";
    }
}

