/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.adorsys.aspsp.xs2a.domain.consent.AuthenticationType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Size;

@ApiModel(description="Authentication object", value="AuthenticationObject")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthenticationObject {
    @ApiModelProperty(value="Type of the authentication method", required=true)
    private AuthenticationType authenticationType;
    @ApiModelProperty(value="Version can be used by differentiating authentication tools used within performing OTP generation in the same authentication type")
    private String authenticationVersion;
    @ApiModelProperty(value="Provided by the ASPSP for the later identification of the authentication method selection.", required=true)
    @Size(max=35)
    private @Size(max=35) String authenticationMethodId;
    @ApiModelProperty(value="Name of the authentication method", required=false, example="redirect")
    private String name;
    @ApiModelProperty(value="Detailed information about the sca method for the PSU", required=false)
    private String explanation;

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getAuthenticationVersion() {
        return this.authenticationVersion;
    }

    public String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public String getName() {
        return this.name;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setAuthenticationVersion(String authenticationVersion) {
        this.authenticationVersion = authenticationVersion;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationObject)) {
            return false;
        }
        AuthenticationObject other = (AuthenticationObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AuthenticationType this$authenticationType = this.getAuthenticationType();
        AuthenticationType other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !((Object)((Object)this$authenticationType)).equals((Object)other$authenticationType)) {
            return false;
        }
        String this$authenticationVersion = this.getAuthenticationVersion();
        String other$authenticationVersion = other.getAuthenticationVersion();
        if (this$authenticationVersion == null ? other$authenticationVersion != null : !this$authenticationVersion.equals(other$authenticationVersion)) {
            return false;
        }
        String this$authenticationMethodId = this.getAuthenticationMethodId();
        String other$authenticationMethodId = other.getAuthenticationMethodId();
        if (this$authenticationMethodId == null ? other$authenticationMethodId != null : !this$authenticationMethodId.equals(other$authenticationMethodId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$explanation = this.getExplanation();
        String other$explanation = other.getExplanation();
        return !(this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthenticationType $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : ((Object)((Object)$authenticationType)).hashCode());
        String $authenticationVersion = this.getAuthenticationVersion();
        result = result * 59 + ($authenticationVersion == null ? 43 : $authenticationVersion.hashCode());
        String $authenticationMethodId = this.getAuthenticationMethodId();
        result = result * 59 + ($authenticationMethodId == null ? 43 : $authenticationMethodId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $explanation = this.getExplanation();
        result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticationObject(authenticationType=" + (Object)((Object)this.getAuthenticationType()) + ", authenticationVersion=" + this.getAuthenticationVersion() + ", authenticationMethodId=" + this.getAuthenticationMethodId() + ", name=" + this.getName() + ", explanation=" + this.getExplanation() + ")";
    }
}

