/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config.rest.consent;

import de.adorsys.aspsp.xs2a.config.rest.consent.ConsentRestErrorHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ConsentRestConfig {
    @Value(value="${rest-consent-config.read-timeout.ms:10000}")
    private int readTimeout;
    @Value(value="${rest-consent-config.connection-timeout.ms:10000}")
    private int connectionTimeout;

    @Bean(name={"consentRestTemplate"})
    public RestTemplate consentRestTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        rest.getMessageConverters().add(new StringHttpMessageConverter());
        rest.setErrorHandler((ResponseErrorHandler)new ConsentRestErrorHandler());
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }
}

