/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.component;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonConverter {
    private static final Logger log = LoggerFactory.getLogger(JsonConverter.class);
    private final ObjectMapper objectMapper;

    public <T> Optional<String> toJson(T object) {
        try {
            return Optional.ofNullable(this.objectMapper.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert object to json: {}", (Throwable)e);
            return Optional.empty();
        }
    }

    public <T> Optional<T> toObject(String json, Class<T> target) {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(json, target));
        }
        catch (IOException e) {
            log.error("Can't convert json to object: {}", (Throwable)e);
            return Optional.empty();
        }
    }

    @ConstructorProperties(value={"objectMapper"})
    public JsonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

