/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.filter;

import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.psd2.validator.signature.TppSignatureValidator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SignatureFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    @Autowired
    private AspspProfileService aspspProfileService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                throw new ServletException("OncePerRequestFilter just supports HTTP requests");
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String encodedTppCert = httpRequest.getHeader("tpp-certificate");
            String signature = httpRequest.getHeader("signature");
            Map headers = this.obtainRequestHeaders(httpRequest);
            TppSignatureValidator tppSignatureValidator = new TppSignatureValidator();
            try {
                tppSignatureValidator.verifySignature(signature, encodedTppCert, headers);
                chain.doFilter(request, response);
            }
            catch (NoSuchAlgorithmException | SignatureException e) {
                log.debug(e.getMessage());
                ((HttpServletResponse)response).sendError(401, e.getMessage());
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private Map<String, String> obtainRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }
}

