/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web.filter;

import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.aspsp.xs2a.service.validator.TppRoleValidationService;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class RoleFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RoleFilter.class);
    @Autowired
    TppRoleValidationService tppRoleValidationService;
    @Autowired
    private AspspProfileService aspspProfileService;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                throw new ServletException("OncePerRequestFilter just supports HTTP requests");
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            TppCertificateData tppCertData = (TppCertificateData)request.getAttribute("tppCertData");
            if (this.tppRoleValidationService.validate(httpRequest, tppCertData.getPspRoles())) {
                chain.doFilter(request, response);
            } else {
                log.debug("Returned if the resource that was referenced in the path exists but cannot be accessed by the TPP or the PSU");
                ((HttpServletResponse)response).sendError(403, "Returned if the resource that was referenced in the path exists but cannot be accessed by the TPP or the PSU");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

