/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.service.PaymentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/periodic-payments/{payment-product}"})
@Api(value="api/v1/periodic-payments/{payment-product}", tags={"PISP, Periodic Payments"}, description="Orders for periodic payments")
public class PeriodicPaymentsController {
    private final PaymentService paymentService;
    private final ResponseMapper responseMapper;

    @ApiOperation(value="The TPP can submit a recurring payment initiation where the starting date, frequency and conditionally an end date is provided. Once authorised by the PSU, the payment then will be executed by the ASPSP, if possible, following this \u201cstanding order\u201d as submitted by the TPP.", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="psu-ip-address", value="192.168.0.26", required=true, paramType="header"), @ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="tpp-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<PaymentInitialisationResponse> createPeriodicPayment(@ApiParam(name="payment-product", value="The addressed payment product endpoint for periodic payments e.g. for a periodic SEPA Credit Transfers", allowableValues="sepa-credit-transfers, target-2-payments,instant-sepa-credit-transfers, cross-border-credit-transfers", required=true) @PathVariable(value="payment-product") String paymentProduct, @ApiParam(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.") @RequestParam(name="tppRedirectPreferred", required=false) boolean tppRedirectPreferred, @ApiParam(name="Periodic Payment", value="All data relevant for the corresponding payment product and necessary for execution of the standing order.", required=true) @RequestBody PeriodicPayment periodicPayment) {
        return this.responseMapper.created(this.paymentService.initiatePeriodicPayment(periodicPayment, paymentProduct, tppRedirectPreferred));
    }

    @ConstructorProperties(value={"paymentService", "responseMapper"})
    public PeriodicPaymentsController(PaymentService paymentService, ResponseMapper responseMapper) {
        this.paymentService = paymentService;
        this.responseMapper = responseMapper;
    }
}

