/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.consent.AccountConsent;
import de.adorsys.aspsp.xs2a.domain.consent.ConsentStatus;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.aspsp.xs2a.domain.consent.CreateConsentResp;
import de.adorsys.aspsp.xs2a.service.ConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.ResponseMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/consents"})
@Api(value="api/v1/consents", tags={"AISP, Consents"}, description="Provides access to the Psu Consents")
public class ConsentInformationController {
    private static final Logger log = LoggerFactory.getLogger(ConsentInformationController.class);
    private final ConsentService consentService;
    private final ResponseMapper responseMapper;

    @ApiOperation(value="Creates an account information consent resource at the ASPSP regarding access to accounts specified in this request.", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="OK", response=CreateConsentResp.class), @ApiResponse(code=400, message="Bad request")})
    @PostMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="tpp-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="psu-id", value="31d50f56-a543-3664-b345-b9a822ae98a7", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<CreateConsentResp> createAccountConsent(@RequestHeader(name="psu-id", required=false) String psuId, @ApiParam(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.") @RequestParam(name="tppRedirectPreferred", required=false) boolean tppRedirectPreferred, @ApiParam(name="withBalance", value="If contained, this function reads the list of accessible payment accounts including the balance.") @RequestParam(name="withBalance", required=false) boolean withBalance, @Valid @RequestBody CreateConsentReq createConsent) {
        ResponseObject response = this.consentService.createAccountConsentsWithResponse(createConsent, withBalance, tppRedirectPreferred, psuId);
        return this.responseMapper.created(response);
    }

    @ApiOperation(value="Can check the status of an account information consent resource", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConsentStatus.class), @ApiResponse(code=400, message="Bad request")})
    @GetMapping(path={"/{consent-id}/status"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="tpp-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<ConsentStatus> getAccountConsentsStatusById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created resource", required=true) @PathVariable(value="consent-id") String consentId) {
        ResponseObject response = this.consentService.getAccountConsentsStatusById(consentId);
        return this.responseMapper.ok(response);
    }

    @ApiOperation(value="Returns the content of an account information consent object", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AccountConsent.class), @ApiResponse(code=400, message="Bad request")})
    @GetMapping(path={"/{consent-id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="tpp-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<AccountConsent> getAccountConsentsInformationById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created resource", required=true) @PathVariable(value="consent-id") String consentId) {
        ResponseObject response = this.consentService.getAccountConsentById(consentId);
        return this.responseMapper.ok(response);
    }

    @ApiOperation(value=" Delete information consent object", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    @DeleteMapping(path={"/{consent-id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tpp-transaction-id", value="16d40f49-a110-4344-a949-f99828ae13c9", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="tpp-request-id", value="2f77a125-aa7a-45c0-b414-cea25a116035", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="signature", value="98c0", required=false, dataType="String", paramType="header"), @ApiImplicitParam(name="tpp-certificate", value="some certificate", required=false, dataType="String", paramType="header")})
    public ResponseEntity<Void> deleteAccountConsent(@ApiParam(name="consent-id", value="The resource-id of consent to be deleted", required=true) @PathVariable(value="consent-id") String consentId) {
        ResponseObject response = this.consentService.deleteAccountConsentsById(consentId);
        return this.responseMapper.delete(response);
    }

    @ConstructorProperties(value={"consentService", "responseMapper"})
    public ConsentInformationController(ConsentService consentService, ResponseMapper responseMapper) {
        this.consentService = consentService;
        this.responseMapper = responseMapper;
    }
}

