/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.validator.header.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.aspsp.xs2a.service.validator.header.RequestHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import javax.validation.constraints.NotNull;

@ApiModel(description="Common request header", value="CommonRequestHeader")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class CommonRequestHeader
implements RequestHeader {
    @ApiModelProperty(value="ID of the transaction as determined by the initiating party", required=true, example="16d40f49-a110-4344-a949-f99828ae13c9")
    @JsonProperty(value="tpp-transaction-id")
    @NotNull
    private UUID tppTransactionId;
    @ApiModelProperty(value="ID of the tpp request", required=true, example="f87cdfbe-a35e-407b-93a4-94fe2edc8d2e")
    @JsonProperty(value="tpp-request-id")
    @NotNull
    private UUID tppRequestId;
    @ApiModelProperty(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP", required=false, example="keyId='Serial_Number_Of_The_TPP\u2019s_certificate',algorithm='rsa- sha256', headers='Digest TPP-Transaction-ID TPP-Request-ID PSU-ID Date', signature='Base64(RSA-SHA256(signing string))")
    @JsonProperty(value="signature")
    private String signature;
    @ApiModelProperty(value="The certificate used for signing the request, in base64 encoding. It shall be contained if a signature is used, see above", required=false, example="TPP's_eIDAS_Certificate")
    @JsonProperty(value="tpp-certificate")
    private String tppCertificate;
    @ApiModelProperty(value="If OAuth2 has been chosen as pre-step to authenticate the PSU", required=false, example="FJFJWOIEJFOIWEJOEWJ")
    @JsonProperty(value="Authorization")
    private String bearerToken;

    public UUID getTppTransactionId() {
        return this.tppTransactionId;
    }

    public UUID getTppRequestId() {
        return this.tppRequestId;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getTppCertificate() {
        return this.tppCertificate;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setTppTransactionId(UUID tppTransactionId) {
        this.tppTransactionId = tppTransactionId;
    }

    public void setTppRequestId(UUID tppRequestId) {
        this.tppRequestId = tppRequestId;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setTppCertificate(String tppCertificate) {
        this.tppCertificate = tppCertificate;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonRequestHeader)) {
            return false;
        }
        CommonRequestHeader other = (CommonRequestHeader)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$tppTransactionId = this.getTppTransactionId();
        UUID other$tppTransactionId = other.getTppTransactionId();
        if (this$tppTransactionId == null ? other$tppTransactionId != null : !((Object)this$tppTransactionId).equals(other$tppTransactionId)) {
            return false;
        }
        UUID this$tppRequestId = this.getTppRequestId();
        UUID other$tppRequestId = other.getTppRequestId();
        if (this$tppRequestId == null ? other$tppRequestId != null : !((Object)this$tppRequestId).equals(other$tppRequestId)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$tppCertificate = this.getTppCertificate();
        String other$tppCertificate = other.getTppCertificate();
        if (this$tppCertificate == null ? other$tppCertificate != null : !this$tppCertificate.equals(other$tppCertificate)) {
            return false;
        }
        String this$bearerToken = this.getBearerToken();
        String other$bearerToken = other.getBearerToken();
        return !(this$bearerToken == null ? other$bearerToken != null : !this$bearerToken.equals(other$bearerToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonRequestHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $tppTransactionId = this.getTppTransactionId();
        result = result * 59 + ($tppTransactionId == null ? 43 : ((Object)$tppTransactionId).hashCode());
        UUID $tppRequestId = this.getTppRequestId();
        result = result * 59 + ($tppRequestId == null ? 43 : ((Object)$tppRequestId).hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $tppCertificate = this.getTppCertificate();
        result = result * 59 + ($tppCertificate == null ? 43 : $tppCertificate.hashCode());
        String $bearerToken = this.getBearerToken();
        result = result * 59 + ($bearerToken == null ? 43 : $bearerToken.hashCode());
        return result;
    }

    public String toString() {
        return "CommonRequestHeader(tppTransactionId=" + this.getTppTransactionId() + ", tppRequestId=" + this.getTppRequestId() + ", signature=" + this.getSignature() + ", tppCertificate=" + this.getTppCertificate() + ", bearerToken=" + this.getBearerToken() + ")";
    }
}

