/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.validator.header;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.service.validator.header.RequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.AccountRequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.ConsentRequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.ErrorMessageHeaderImpl;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.FundsConfirmationRequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.NotMatchedHeaderImpl;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.PaymentInitiationRequestHeader;
import de.adorsys.aspsp.xs2a.service.validator.header.impl.PaymentRequestHeader;
import de.adorsys.aspsp.xs2a.web.AccountController;
import de.adorsys.aspsp.xs2a.web.BulkPaymentInitiationController;
import de.adorsys.aspsp.xs2a.web.ConsentInformationController;
import de.adorsys.aspsp.xs2a.web.FundsConfirmationController;
import de.adorsys.aspsp.xs2a.web.PaymentInitiationController;
import de.adorsys.aspsp.xs2a.web.PeriodicPaymentsController;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersFactory.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<Class, Class> controllerClassMap = new HashMap();

    public static RequestHeader getHeadersImpl(Map<String, String> requestHeadersMap, Class controllerClass) {
        Class headerClass = (Class)controllerClassMap.get(controllerClass);
        if (headerClass == null) {
            return new NotMatchedHeaderImpl();
        }
        try {
            return (RequestHeader)MAPPER.convertValue(requestHeadersMap, headerClass);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.error("Error request headers conversion: " + exception.getMessage());
            return new ErrorMessageHeaderImpl(exception.getMessage());
        }
    }

    static {
        controllerClassMap.put(AccountController.class, AccountRequestHeader.class);
        controllerClassMap.put(ConsentInformationController.class, ConsentRequestHeader.class);
        controllerClassMap.put(PaymentInitiationController.class, PaymentRequestHeader.class);
        controllerClassMap.put(BulkPaymentInitiationController.class, PaymentInitiationRequestHeader.class);
        controllerClassMap.put(PeriodicPaymentsController.class, PaymentInitiationRequestHeader.class);
        controllerClassMap.put(FundsConfirmationController.class, FundsConfirmationRequestHeader.class);
    }
}

