/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.validator;

import de.adorsys.psd2.validator.certificate.util.TppRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Service;

@Service
public class TppRoleValidationService {
    private Map<String, TppRole> patternRoleMap;
    private List<AntPathRequestMatcher> matchers;
    private static final String API_BASE_PATH = "/api/v1";

    @PostConstruct
    void initCertificatePathMatchers() {
        this.patternRoleMap = new HashMap();
        this.patternRoleMap.put("/api/v1/accounts/**", TppRole.AISP);
        this.patternRoleMap.put("/api/v1/consents/**", TppRole.AISP);
        this.patternRoleMap.put("/api/v1/funds-confirmations/**", TppRole.PIISP);
        this.patternRoleMap.put("/api/v1/bulk-payments/**", TppRole.PISP);
        this.patternRoleMap.put("/api/v1/payments/**", TppRole.PISP);
        this.patternRoleMap.put("/api/v1/periodic-payments/**", TppRole.PISP);
        this.regexMatchers(this.patternRoleMap.keySet());
    }

    private void regexMatchers(Set<String> regexPatterns) {
        this.matchers = new ArrayList();
        for (String pattern : regexPatterns) {
            this.matchers.add(new AntPathRequestMatcher(pattern));
        }
    }

    public boolean validate(HttpServletRequest request, List<TppRole> roles) {
        for (AntPathRequestMatcher matcher : this.matchers) {
            if (!matcher.matches(request)) continue;
            TppRole tppRole = (TppRole)this.patternRoleMap.get(matcher.getPattern());
            return Optional.ofNullable(roles).map(r -> r.contains(tppRole)).orElse(false);
        }
        return true;
    }
}

