/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ResponseMapper {
    public ResponseEntity ok() {
        return ResponseEntity.ok().build();
    }

    public <T> ResponseEntity<T> ok(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.OK);
    }

    public <T> ResponseEntity<T> created(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.CREATED);
    }

    public <T> ResponseEntity<T> delete(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.NO_CONTENT);
    }

    private <T> ResponseEntity<T> getEntity(ResponseObject<T> response, HttpStatus status) {
        return response.hasError() ? this.enrichError(response.getError()) : new ResponseEntity(response.getBody(), status);
    }

    private ResponseEntity enrichError(MessageError error) {
        return new ResponseEntity((Object)error, HttpStatus.valueOf((int)error.getTppMessage().getCode().getCode()));
    }
}

