/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisAccountReference;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisAmount;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Balances;
import de.adorsys.aspsp.xs2a.domain.CashAccountType;
import de.adorsys.aspsp.xs2a.domain.SingleBalance;
import de.adorsys.aspsp.xs2a.domain.Transactions;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.account.AccountReport;
import de.adorsys.aspsp.xs2a.domain.code.BankTransactionCode;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountType;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiBalances;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiAmount;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AccountMapper {
    public AccountDetails mapToAccountDetails(SpiAccountDetails accountDetails) {
        return Optional.ofNullable(accountDetails).map(ad -> new AccountDetails(ad.getId(), ad.getIban(), ad.getBban(), ad.getPan(), ad.getMaskedPan(), ad.getMsisdn(), ad.getCurrency(), ad.getName(), ad.getAccountType(), this.mapToAccountType(ad.getCashSpiAccountType()), ad.getBic(), this.mapToBalancesList(ad.getBalances()))).orElse(null);
    }

    private CashAccountType mapToAccountType(SpiAccountType spiAccountType) {
        return Optional.ofNullable(spiAccountType).map(type -> CashAccountType.valueOf((String)type.name())).orElse(null);
    }

    public List<Balances> mapToBalancesList(List<SpiBalances> spiBalances) {
        if (CollectionUtils.isEmpty(spiBalances)) {
            return new ArrayList<Balances>();
        }
        return spiBalances.stream().map(arg_0 -> this.mapToBalances(arg_0)).collect(Collectors.toList());
    }

    private Balances mapToBalances(SpiBalances spiBalances) {
        return Optional.ofNullable(spiBalances).map(b -> {
            Balances balances = new Balances();
            balances.setAuthorised(this.mapToSingleBalance(b.getAuthorised()));
            balances.setClosingBooked(this.mapToSingleBalance(b.getClosingBooked()));
            balances.setExpected(this.mapToSingleBalance(b.getExpected()));
            balances.setInterimAvailable(this.mapToSingleBalance(b.getInterimAvailable()));
            balances.setOpeningBooked(this.mapToSingleBalance(b.getOpeningBooked()));
            return balances;
        }).orElse(null);
    }

    private SingleBalance mapToSingleBalance(SpiAccountBalance spiAccountBalance) {
        return Optional.ofNullable(spiAccountBalance).map(b -> {
            SingleBalance singleBalance = new SingleBalance();
            singleBalance.setAmount(this.mapToAmount(b.getSpiAmount()));
            singleBalance.setDate(b.getDate());
            singleBalance.setLastActionDateTime(b.getLastActionDateTime());
            return singleBalance;
        }).orElse(null);
    }

    public Amount mapToAmount(SpiAmount spiAmount) {
        return Optional.ofNullable(spiAmount).map(a -> {
            Amount amount = new Amount();
            amount.setContent(a.getContent().toString());
            amount.setCurrency(a.getCurrency());
            return amount;
        }).orElse(null);
    }

    public SpiAmount mapToSpiAmount(Amount amount) {
        return Optional.ofNullable(amount).map(am -> new SpiAmount(am.getCurrency(), new BigDecimal(am.getContent()))).orElse(null);
    }

    public PisAmount mapToPisAmount(Amount amount) {
        return Optional.ofNullable(amount).map(am -> new PisAmount(am.getCurrency(), new BigDecimal(am.getContent()))).orElse(null);
    }

    public Optional<AccountReport> mapToAccountReport(List<SpiTransaction> spiTransactions) {
        if (spiTransactions.isEmpty()) {
            return Optional.empty();
        }
        Transactions[] booked = (Transactions[])spiTransactions.stream().filter(transaction -> transaction.getBookingDate() != null).map(arg_0 -> this.mapToTransaction(arg_0)).toArray(Transactions[]::new);
        Transactions[] pending = (Transactions[])spiTransactions.stream().filter(transaction -> transaction.getBookingDate() == null).map(arg_0 -> this.mapToTransaction(arg_0)).toArray(Transactions[]::new);
        return Optional.of(new AccountReport(booked, pending));
    }

    public Transactions mapToTransaction(SpiTransaction spiTransaction) {
        return Optional.ofNullable(spiTransaction).map(t -> {
            Transactions transactions = new Transactions();
            transactions.setAmount(this.mapToAmount(t.getSpiAmount()));
            transactions.setBankTransactionCodeCode(new BankTransactionCode(t.getBankTransactionCodeCode()));
            transactions.setBookingDate(t.getBookingDate());
            transactions.setValueDate(t.getValueDate());
            transactions.setCreditorAccount(this.mapToAccountReference(t.getCreditorAccount()));
            transactions.setDebtorAccount(this.mapToAccountReference(t.getDebtorAccount()));
            transactions.setCreditorId(t.getCreditorId());
            transactions.setCreditorName(t.getCreditorName());
            transactions.setUltimateCreditor(t.getUltimateCreditor());
            transactions.setDebtorName(t.getDebtorName());
            transactions.setUltimateDebtor(t.getUltimateDebtor());
            transactions.setEndToEndId(t.getEndToEndId());
            transactions.setMandateId(t.getMandateId());
            transactions.setPurposeCode(new PurposeCode(t.getPurposeCode()));
            transactions.setTransactionId(t.getTransactionId());
            transactions.setRemittanceInformationStructured(t.getRemittanceInformationStructured());
            transactions.setRemittanceInformationUnstructured(t.getRemittanceInformationUnstructured());
            return transactions;
        }).orElse(null);
    }

    public AccountReference mapToAccountReference(SpiAccountReference spiAccountReference) {
        return Optional.ofNullable(spiAccountReference).map(ar -> {
            AccountReference accountReference = new AccountReference();
            accountReference.setIban(ar.getIban());
            accountReference.setBban(ar.getBban());
            accountReference.setPan(ar.getPan());
            accountReference.setMaskedPan(ar.getMaskedPan());
            accountReference.setMsisdn(ar.getMsisdn());
            accountReference.setCurrency(ar.getCurrency());
            return accountReference;
        }).orElse(null);
    }

    public List<SpiAccountReference> mapToSpiAccountReferences(List<AccountReference> references) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(arg_0 -> this.mapToSpiAccountReference(arg_0)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public SpiAccountReference mapToSpiAccountReference(AccountReference account) {
        return Optional.ofNullable(account).map(ac -> new SpiAccountReference(ac.getIban(), ac.getBban(), ac.getPan(), ac.getMaskedPan(), ac.getMsisdn(), ac.getCurrency())).orElse(null);
    }

    public PisAccountReference mapToPisAccountReference(AccountReference account) {
        return Optional.ofNullable(account).map(ac -> new PisAccountReference(ac.getIban(), ac.getBban(), ac.getPan(), ac.getMaskedPan(), ac.getMsisdn(), ac.getCurrency())).orElse(null);
    }

    public List<AccountReference> mapToAccountReferences(List<SpiAccountReference> references) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(arg_0 -> this.mapToAccountReference(arg_0)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<AccountReference> mapToAccountReferencesFromDetails(List<SpiAccountDetails> details) {
        return Optional.ofNullable(details).map(det -> det.stream().map(arg_0 -> this.mapToAccountDetails(arg_0)).map(arg_0 -> this.mapToAccountReference(arg_0)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private AccountReference mapToAccountReference(AccountDetails details) {
        return Optional.ofNullable(details).map(d -> {
            AccountReference reference = new AccountReference();
            reference.setIban(d.getIban());
            reference.setBban(d.getBban());
            reference.setPan(d.getPan());
            reference.setMaskedPan(d.getMaskedPan());
            reference.setMsisdn(d.getMsisdn());
            reference.setCurrency(d.getCurrency());
            return reference;
        }).orElse(null);
    }
}

