/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.consent.pis;

import de.adorsys.aspsp.xs2a.config.rest.consent.PisConsentRemoteUrls;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPeriodicPayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisSinglePayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentBulkPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentPeriodicPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PisConsentService {
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PisConsentRemoteUrls remotePisConsentUrls;
    private final PaymentMapper paymentMapper;

    public String createPisConsentForSinglePaymentAndGetId(SinglePayments singlePayment) {
        PisSinglePayment pisSinglePayment = this.paymentMapper.mapToPisSinglePayment(singlePayment);
        ResponseEntity responseEntity = this.consentRestTemplate.postForEntity(this.remotePisConsentUrls.createPisConsent(), (Object)new PisConsentRequest(pisSinglePayment), String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public String createPisConsentForBulkPaymentAndGetId(List<SinglePayments> payments) {
        List pisPayments = this.paymentMapper.mapToPisSinglePaymentList(payments);
        ResponseEntity responseEntity = this.consentRestTemplate.postForEntity(this.remotePisConsentUrls.createPisBulkPaymentConsent(), (Object)new PisConsentBulkPaymentRequest(pisPayments), String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public String createPisConsentForPeriodicPaymentAndGetId(PeriodicPayment periodicPayment) {
        PisPeriodicPayment pisPeriodicPayment = this.paymentMapper.mapToPisPeriodicPayment(periodicPayment);
        ResponseEntity responseEntity = this.consentRestTemplate.postForEntity(this.remotePisConsentUrls.createPisPeriodicPaymentConsent(), (Object)new PisConsentPeriodicPaymentRequest(pisPeriodicPayment), String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    @ConstructorProperties(value={"consentRestTemplate", "remotePisConsentUrls", "paymentMapper"})
    public PisConsentService(RestTemplate consentRestTemplate, PisConsentRemoteUrls remotePisConsentUrls, PaymentMapper paymentMapper) {
        this.consentRestTemplate = consentRestTemplate;
        this.remotePisConsentUrls = remotePisConsentUrls;
        this.paymentMapper = paymentMapper;
    }
}

