/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.pis.PaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.aspsp.xs2a.domain.pis.SinglePayments;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.AccountService;
import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.aspsp.xs2a.service.consent.pis.PisConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private final PaymentSpi paymentSpi;
    private final PaymentMapper paymentMapper;
    private final AccountService accountService;
    private final PisConsentService pisConsentService;
    private final AspspProfileService aspspProfileService;

    public ResponseObject<TransactionStatus> getPaymentStatusById(String paymentId, String paymentProduct) {
        TransactionStatus transactionStatus = this.paymentMapper.mapToTransactionStatus(this.paymentSpi.getPaymentStatusById(paymentId, paymentProduct));
        return ResponseObject.builder().body((Object)transactionStatus).build();
    }

    public ResponseObject<PaymentInitialisationResponse> initiatePeriodicPayment(PeriodicPayment periodicPayment, String paymentProduct, boolean tppRedirectPreferred) {
        ResponseObject paymentRelatedErrors = this.containsPeriodicPaymentRelatedErrors(periodicPayment, paymentProduct);
        if (paymentRelatedErrors.hasError()) {
            return ResponseObject.builder().fail(paymentRelatedErrors.getError()).build();
        }
        Optional paymentInitiation = this.aspspProfileService.isRedirectMode() ? this.getPeriodicPaymentResponseWhenRedirectMode(periodicPayment) : this.getPeriodicPaymentResponseWhenOAuthMode(periodicPayment, paymentProduct, tppRedirectPreferred);
        return paymentInitiation.map(resp -> ResponseObject.builder().body(resp).build()).orElse(ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build());
    }

    public ResponseObject<List<PaymentInitialisationResponse>> createBulkPayments(List<SinglePayments> payments, String paymentProduct, boolean tppRedirectPreferred) {
        List paymentResponses;
        if (CollectionUtils.isEmpty(payments)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
        }
        ArrayList<SinglePayments> validPayments = new ArrayList<SinglePayments>();
        ArrayList invalidPayments = new ArrayList();
        for (SinglePayments s : payments) {
            ResponseObject paymentRelatedErrors = this.containsSinglePaymentRelatedErrors(s, paymentProduct);
            if (paymentRelatedErrors.hasError()) {
                this.paymentMapper.mapToPaymentInitResponseFailedPayment(s == null ? new SinglePayments() : s, paymentRelatedErrors.getError().getTppMessage().getCode(), tppRedirectPreferred).map(invalidPayments::add);
                continue;
            }
            validPayments.add(s);
        }
        if (CollectionUtils.isNotEmpty(validPayments) && CollectionUtils.isNotEmpty((Collection)(paymentResponses = this.getBulkPaymentResponses(paymentProduct, tppRedirectPreferred, validPayments))) && paymentResponses.stream().anyMatch(pr -> pr.getTransactionStatus() != TransactionStatus.RJCT)) {
            paymentResponses.addAll(invalidPayments);
            return ResponseObject.builder().body((Object)paymentResponses).build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build();
    }

    public ResponseObject<PaymentInitialisationResponse> createPaymentInitiation(SinglePayments singlePayment, String paymentProduct, boolean tppRedirectPreferred) {
        ResponseObject paymentRelatedErrors = this.containsSinglePaymentRelatedErrors(singlePayment, paymentProduct);
        if (paymentRelatedErrors.hasError()) {
            return ResponseObject.builder().fail(paymentRelatedErrors.getError()).build();
        }
        Optional paymentInitResp = this.aspspProfileService.isRedirectMode() ? this.getSinglePaymentResponseWhenRedirectMode(singlePayment) : this.getSinglePaymentResponseWhenOAuthMode(singlePayment, paymentProduct, tppRedirectPreferred);
        return paymentInitResp.map(resp -> ResponseObject.builder().body(resp).build()).orElse(ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PAYMENT_FAILED))).build());
    }

    private List<PaymentInitialisationResponse> getBulkPaymentResponses(String paymentProduct, boolean tppRedirectPreferred, List<SinglePayments> validPayments) {
        return this.aspspProfileService.isRedirectMode() ? this.getBulkPaymentResponseWhenRedirectMode(validPayments) : this.getBulkPaymentResponseWhenOAuthMode(validPayments, paymentProduct, tppRedirectPreferred);
    }

    private ResponseObject containsSinglePaymentRelatedErrors(SinglePayments payment, String paymentProduct) {
        return payment != null && payment.isValidDated() ? this.containsPaymentRelatedErrors(payment, paymentProduct) : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
    }

    private ResponseObject containsPeriodicPaymentRelatedErrors(PeriodicPayment payment, String paymentProduct) {
        return payment != null && payment.isValidDate() ? this.containsPaymentRelatedErrors((SinglePayments)payment, paymentProduct) : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR))).build();
    }

    private ResponseObject containsPaymentRelatedErrors(SinglePayments payment, String paymentProduct) {
        if (!this.accountService.getAccountDetailsByAccountReference(payment.getDebtorAccount()).isPresent() && !this.accountService.getAccountDetailsByAccountReference(payment.getCreditorAccount()).isPresent()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_400))).build();
        }
        if (this.accountService.isInvalidPaymentProductForPsu(payment.getDebtorAccount(), paymentProduct)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.PRODUCT_INVALID))).build();
        }
        return ResponseObject.builder().build();
    }

    private Optional<PaymentInitialisationResponse> getPeriodicPaymentResponseWhenRedirectMode(PeriodicPayment periodicPayment) {
        String pisConsentId = this.pisConsentService.createPisConsentForPeriodicPaymentAndGetId(periodicPayment);
        if (StringUtils.isNotBlank((CharSequence)pisConsentId)) {
            PaymentInitialisationResponse response = new PaymentInitialisationResponse();
            response.setTransactionStatus(TransactionStatus.ACCP);
            response.setPisConsentId(pisConsentId);
            response.setIban(periodicPayment.getDebtorAccount().getIban());
            return Optional.of(response);
        }
        return Optional.empty();
    }

    private Optional<PaymentInitialisationResponse> getPeriodicPaymentResponseWhenOAuthMode(PeriodicPayment periodicPayment, String paymentProduct, boolean tppRedirectPreferred) {
        return this.createPeriodicPaymentAndGetResponse(periodicPayment, paymentProduct, tppRedirectPreferred);
    }

    private Optional<PaymentInitialisationResponse> createPeriodicPaymentAndGetResponse(PeriodicPayment periodicPayment, String paymentProduct, boolean tppRedirectPreferred) {
        SpiPeriodicPayment spiPeriodicPayment = this.paymentMapper.mapToSpiPeriodicPayment(periodicPayment);
        return this.paymentMapper.mapToPaymentInitializationResponse(this.paymentSpi.initiatePeriodicPayment(spiPeriodicPayment, paymentProduct, tppRedirectPreferred));
    }

    private List<PaymentInitialisationResponse> getBulkPaymentResponseWhenRedirectMode(List<SinglePayments> payments) {
        String pisConsentId = this.pisConsentService.createPisConsentForBulkPaymentAndGetId(payments);
        if (!StringUtils.isBlank((CharSequence)pisConsentId)) {
            PaymentInitialisationResponse response = new PaymentInitialisationResponse();
            response.setTransactionStatus(TransactionStatus.ACCP);
            response.setPisConsentId(pisConsentId);
            response.setIban(payments.get(0).getDebtorAccount().getIban());
            return new ArrayList<PaymentInitialisationResponse>(Collections.singletonList(response));
        }
        return Collections.emptyList();
    }

    private List<PaymentInitialisationResponse> getBulkPaymentResponseWhenOAuthMode(List<SinglePayments> payments, String paymentProduct, boolean tppRedirectPreferred) {
        return this.createBulkPaymentAndGetResponse(payments, paymentProduct, tppRedirectPreferred);
    }

    private List<PaymentInitialisationResponse> createBulkPaymentAndGetResponse(List<SinglePayments> payments, String paymentProduct, boolean tppRedirectPreferred) {
        List spiPayments = this.paymentMapper.mapToSpiSinglePaymentList(payments);
        List spiPaymentInitiations = this.paymentSpi.createBulkPayments(spiPayments, paymentProduct, tppRedirectPreferred);
        return spiPaymentInitiations.stream().map(arg_0 -> ((PaymentMapper)this.paymentMapper).mapToPaymentInitializationResponse(arg_0)).filter(Optional::isPresent).map(Optional::get).peek(resp -> {
            if (StringUtils.isBlank((CharSequence)resp.getPaymentId()) || resp.getTransactionStatus() == TransactionStatus.RJCT) {
                resp.setTppMessages(new MessageErrorCode[]{MessageErrorCode.PAYMENT_FAILED});
                resp.setTransactionStatus(TransactionStatus.RJCT);
            }
        }).collect(Collectors.toList());
    }

    private Optional<PaymentInitialisationResponse> getSinglePaymentResponseWhenRedirectMode(SinglePayments singlePayment) {
        String pisConsentId = this.pisConsentService.createPisConsentForSinglePaymentAndGetId(singlePayment);
        if (!StringUtils.isBlank((CharSequence)pisConsentId)) {
            PaymentInitialisationResponse response = new PaymentInitialisationResponse();
            response.setTransactionStatus(TransactionStatus.RCVD);
            response.setPisConsentId(pisConsentId);
            response.setIban(singlePayment.getDebtorAccount().getIban());
            return Optional.of(response);
        }
        return Optional.empty();
    }

    private Optional<PaymentInitialisationResponse> getSinglePaymentResponseWhenOAuthMode(SinglePayments singlePayment, String paymentProduct, boolean tppRedirectPreferred) {
        return this.createSinglePaymentAndGetResponse(singlePayment, paymentProduct, tppRedirectPreferred);
    }

    private Optional<PaymentInitialisationResponse> createSinglePaymentAndGetResponse(SinglePayments singlePayment, String paymentProduct, boolean tppRedirectPreferred) {
        SpiSinglePayments spiSinglePayments = this.paymentMapper.mapToSpiSinglePayments(singlePayment);
        SpiPaymentInitialisationResponse spiPeriodicPaymentResp = this.paymentSpi.createPaymentInitiation(spiSinglePayments, paymentProduct, tppRedirectPreferred);
        return this.paymentMapper.mapToPaymentInitializationResponse(spiPeriodicPaymentResp);
    }

    @ConstructorProperties(value={"paymentSpi", "paymentMapper", "accountService", "pisConsentService", "aspspProfileService"})
    public PaymentService(PaymentSpi paymentSpi, PaymentMapper paymentMapper, AccountService accountService, PisConsentService pisConsentService, AspspProfileService aspspProfileService) {
        this.paymentSpi = paymentSpi;
        this.paymentMapper = paymentMapper;
        this.accountService = accountService;
        this.pisConsentService = pisConsentService;
        this.aspspProfileService = aspspProfileService;
    }
}

