/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.Balances;
import de.adorsys.aspsp.xs2a.domain.BookingStatus;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.ResponseObject;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.Transactions;
import de.adorsys.aspsp.xs2a.domain.account.AccountDetails;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.account.AccountReport;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccess;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.service.ConsentService;
import de.adorsys.aspsp.xs2a.service.consent.ais.AisConsentService;
import de.adorsys.aspsp.xs2a.service.mapper.AccountMapper;
import de.adorsys.aspsp.xs2a.service.validator.ValidationGroup;
import de.adorsys.aspsp.xs2a.service.validator.ValueValidatorService;
import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    private final AccountSpi accountSpi;
    private final AccountMapper accountMapper;
    private final ValueValidatorService validatorService;
    private final ConsentService consentService;
    private final AisConsentService aisConsentService;
    private static final String TPP_ID = "This is a test TppId";

    public ResponseObject<Map<String, List<AccountDetails>>> getAccountDetailsList(String consentId, boolean withBalance, boolean psuInvolved) {
        ResponseObject allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        List accountDetails = this.getAccountDetailsFromReferences(withBalance, (AccountAccess)allowedAccountData.getBody());
        ResponseObject response = accountDetails.isEmpty() ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build() : ResponseObject.builder().body(Collections.singletonMap("accountList", accountDetails)).build();
        this.aisConsentService.consentActionLog(TPP_ID, consentId, withBalance, TypeAccess.ACCOUNT, response);
        return response;
    }

    public ResponseObject<AccountDetails> getAccountDetails(String consentId, String accountId, boolean withBalance, boolean psuInvolved) {
        ResponseObject allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails(this.accountSpi.readAccountDetails(accountId));
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = withBalance ? this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), ((AccountAccess)allowedAccountData.getBody()).getBalances()) : this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), ((AccountAccess)allowedAccountData.getBody()).getAccounts());
        ResponseObject.ResponseBuilder builder = ResponseObject.builder();
        builder = isValid ? (withBalance ? builder.body((Object)accountDetails) : builder.body((Object)this.getAccountDetailNoBalances(accountDetails))) : builder.fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID)));
        this.aisConsentService.consentActionLog(TPP_ID, consentId, withBalance, TypeAccess.ACCOUNT, builder.build());
        return builder.build();
    }

    public ResponseObject<List<Balances>> getBalances(String consentId, String accountId, boolean psuInvolved) {
        ResponseObject allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails(this.accountSpi.readAccountDetails(accountId));
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), ((AccountAccess)allowedAccountData.getBody()).getBalances());
        ResponseObject response = isValid ? ResponseObject.builder().body((Object)accountDetails.getBalances()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.aisConsentService.consentActionLog(TPP_ID, consentId, false, TypeAccess.BALANCE, response);
        return response;
    }

    public ResponseObject<AccountReport> getAccountReport(String consentId, String accountId, LocalDate dateFrom, LocalDate dateTo, String transactionId, boolean psuInvolved, BookingStatus bookingStatus, boolean withBalance, boolean deltaList) {
        ResponseObject allowedAccountData = this.consentService.getValidatedConsent(consentId);
        if (allowedAccountData.hasError()) {
            return ResponseObject.builder().fail(allowedAccountData.getError()).build();
        }
        AccountDetails accountDetails = this.accountMapper.mapToAccountDetails(this.accountSpi.readAccountDetails(accountId));
        if (accountDetails == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_404))).build();
        }
        boolean isValid = this.consentService.isValidAccountByAccess(accountDetails.getIban(), accountDetails.getCurrency(), ((AccountAccess)allowedAccountData.getBody()).getTransactions());
        Optional report = this.getAccountReport(accountId, dateFrom, dateTo, transactionId, bookingStatus);
        ResponseObject response = isValid && report.isPresent() ? ResponseObject.builder().body(report.get()).build() : ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        this.aisConsentService.consentActionLog(TPP_ID, consentId, withBalance, TypeAccess.TRANSACTION, response);
        return response;
    }

    private List<AccountDetails> getAccountDetailsFromReferences(boolean withBalance, AccountAccess accountAccess) {
        List references = withBalance ? accountAccess.getBalances() : accountAccess.getAccounts();
        List details = this.getAccountDetailsFromReferences(references);
        return withBalance ? details : this.getAccountDetailsNoBalances(details);
    }

    private List<AccountDetails> getAccountDetailsFromReferences(List<AccountReference> references) {
        return CollectionUtils.isEmpty(references) ? Collections.emptyList() : references.stream().map(arg_0 -> this.getAccountDetailsByAccountReference(arg_0)).filter(Optional::isPresent).collect(Collectors.mapping(Optional::get, Collectors.toList()));
    }

    private List<AccountDetails> getAccountDetailsNoBalances(List<AccountDetails> details) {
        return details.stream().map(arg_0 -> this.getAccountDetailNoBalances(arg_0)).collect(Collectors.toList());
    }

    private AccountDetails getAccountDetailNoBalances(AccountDetails detail) {
        return new AccountDetails(detail.getId(), detail.getIban(), detail.getBban(), detail.getPan(), detail.getMaskedPan(), detail.getMsisdn(), detail.getCurrency(), detail.getName(), detail.getAccountType(), detail.getCashAccountType(), detail.getBic(), null);
    }

    private Optional<AccountReport> getAccountReport(String accountId, LocalDate dateFrom, LocalDate dateTo, String transactionId, BookingStatus bookingStatus) {
        return StringUtils.isNotBlank((CharSequence)transactionId) ? this.getAccountReportByTransaction(transactionId, accountId) : this.getAccountReportByPeriod(accountId, dateFrom, dateTo).map(r -> this.filterByBookingStatus(r, bookingStatus));
    }

    private AccountReport filterByBookingStatus(AccountReport report, BookingStatus bookingStatus) {
        return new AccountReport(bookingStatus == BookingStatus.BOOKED || bookingStatus == BookingStatus.BOTH ? report.getBooked() : new Transactions[]{}, bookingStatus == BookingStatus.PENDING || bookingStatus == BookingStatus.BOTH ? report.getPending() : new Transactions[]{});
    }

    private Optional<AccountReport> getAccountReportByTransaction(String transactionId, String accountId) {
        this.validateAccountIdTransactionId(accountId, transactionId);
        Optional transaction = this.accountSpi.readTransactionById(transactionId, accountId);
        return this.accountMapper.mapToAccountReport(transaction.map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private Optional<AccountReport> getAccountReportByPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        LocalDate dateToChecked = Optional.ofNullable(dateTo).orElse(LocalDate.now());
        this.validateAccountIdPeriod(accountId, dateFrom, dateToChecked);
        return this.accountMapper.mapToAccountReport(this.accountSpi.readTransactionsByPeriod(accountId, dateFrom, dateTo));
    }

    Optional<AccountDetails> getAccountDetailsByAccountReference(AccountReference reference) {
        return Optional.ofNullable(reference).map(ref -> this.accountSpi.readAccountDetailsByIban(ref.getIban())).map(Collection::stream).flatMap(accDts -> accDts.filter(spiAcc -> spiAcc.getCurrency() == reference.getCurrency()).findFirst()).map(arg_0 -> ((AccountMapper)this.accountMapper).mapToAccountDetails(arg_0));
    }

    private void validateAccountIdPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        ValidationGroup fieldValidator = new ValidationGroup();
        fieldValidator.setAccountId(accountId);
        fieldValidator.setDateFrom(dateFrom);
        fieldValidator.setDateTo(dateTo);
        this.validatorService.validate((Object)fieldValidator, new Class[]{ValidationGroup.AccountIdAndPeriodIsValid.class});
    }

    private void validateAccountIdTransactionId(String accountId, String transactionId) {
        ValidationGroup fieldValidator = new ValidationGroup();
        fieldValidator.setAccountId(accountId);
        fieldValidator.setTransactionId(transactionId);
        this.validatorService.validate((Object)fieldValidator, new Class[]{ValidationGroup.AccountIdAndTransactionIdIsValid.class});
    }

    boolean isInvalidPaymentProductForPsu(AccountReference reference, String paymentProduct) {
        return !this.accountSpi.readPsuAllowedPaymentProductList(this.accountMapper.mapToSpiAccountReference(reference)).contains(paymentProduct);
    }

    @ConstructorProperties(value={"accountSpi", "accountMapper", "validatorService", "consentService", "aisConsentService"})
    public AccountService(AccountSpi accountSpi, AccountMapper accountMapper, ValueValidatorService validatorService, ConsentService consentService, AisConsentService aisConsentService) {
        this.accountSpi = accountSpi;
        this.accountMapper = accountMapper;
        this.validatorService = validatorService;
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
    }
}

