/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.exception;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import io.swagger.annotations.ApiModelProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageError {
    @JsonUnwrapped
    @ApiModelProperty(value="Transaction status", example="Rejected")
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Tpp messages information of the Berlin Group XS2A Interface")
    private TppMessageInformation tppMessage;

    public MessageError(TppMessageInformation tppMessage) {
        this(TransactionStatus.RJCT, tppMessage);
    }

    public MessageError(TransactionStatus status, TppMessageInformation tppMessage) {
        this.transactionStatus = status;
        this.tppMessage = tppMessage;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public TppMessageInformation getTppMessage() {
        return this.tppMessage;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTppMessage(TppMessageInformation tppMessage) {
        this.tppMessage = tppMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageError)) {
            return false;
        }
        MessageError other = (MessageError)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        TppMessageInformation this$tppMessage = this.getTppMessage();
        TppMessageInformation other$tppMessage = other.getTppMessage();
        return !(this$tppMessage == null ? other$tppMessage != null : !this$tppMessage.equals(other$tppMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        TppMessageInformation $tppMessage = this.getTppMessage();
        result = result * 59 + ($tppMessage == null ? 43 : $tppMessage.hashCode());
        return result;
    }

    public String toString() {
        return "MessageError(transactionStatus=" + this.getTransactionStatus() + ", tppMessage=" + this.getTppMessage() + ")";
    }
}

