/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.exception;

import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TppMessageInformation;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import de.adorsys.aspsp.xs2a.exception.MessageError;
import de.adorsys.aspsp.xs2a.exception.RestException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
public class GlobalExceptionHandlerController {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerController.class);

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity validationException(ValidationException ex, HandlerMethod handlerMethod) {
        log.warn("ValidationException handled in service: {}, message: {} ", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.FORMAT_ERROR).text(ex.getMessage())), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity httpMessageException(HttpMessageNotReadableException ex, HandlerMethod handlerMethod) {
        log.warn("HttpMessageNotReadableException handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return new ResponseEntity((Object)status.getReasonPhrase(), status);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity exception(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)status.getReasonPhrase(), status);
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity restException(RestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {} ", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)new MessageError(new TppMessageInformation(MessageCategory.ERROR, ex.getMessageErrorCode()).text(ex.getMessage())), ex.getHttpStatus());
    }
}

