/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.Links;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.domain.TransactionStatus;
import de.adorsys.aspsp.xs2a.domain.consent.AuthenticationObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;

@ApiModel(description="Response Body generated by the Payment Service")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PaymentInitialisationResponse {
    @JsonUnwrapped
    @ApiModelProperty(value="The transaction status is filled with value of the ISO20022 data table", required=true, example="ACCP")
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Resource identification of the generated payment initiation resource.", required=true, example="qwer3456tzui7890")
    private String paymentId;
    @ApiModelProperty(value="Can be used by the ASPSP to transport transaction fees relevant for the underlying payments.")
    private Amount transactionFees;
    @ApiModelProperty(value="If equals true, the transaction will involve specific transaction cost as shown by the ASPSP in their public price list or as agreed between ASPSP and PSU.", example="false")
    private boolean transactionFeeIndicator;
    @ApiModelProperty(value="This data element might be contained, if SCA is required and if the PSU has a choice between different authentication methods")
    private AuthenticationObject[] scaMethods;
    @ApiModelProperty(value="Text to be displayed to the PSU")
    private String psuMessage;
    @ApiModelProperty(value="Messages to the TPP on operational issues.")
    private MessageErrorCode[] tppMessages;
    @ApiModelProperty(value="Links: a list of hyperlinks to be recognised by the TPP.")
    @JsonProperty(value="_links")
    private Links links;
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.")
    private boolean tppRedirectPreferred;
    @JsonIgnore
    private String iban;
    @JsonIgnore
    private String pisConsentId;

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Amount getTransactionFees() {
        return this.transactionFees;
    }

    public boolean isTransactionFeeIndicator() {
        return this.transactionFeeIndicator;
    }

    public AuthenticationObject[] getScaMethods() {
        return this.scaMethods;
    }

    public String getPsuMessage() {
        return this.psuMessage;
    }

    public MessageErrorCode[] getTppMessages() {
        return this.tppMessages;
    }

    public Links getLinks() {
        return this.links;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public String getIban() {
        return this.iban;
    }

    public String getPisConsentId() {
        return this.pisConsentId;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setTransactionFees(Amount transactionFees) {
        this.transactionFees = transactionFees;
    }

    public void setTransactionFeeIndicator(boolean transactionFeeIndicator) {
        this.transactionFeeIndicator = transactionFeeIndicator;
    }

    public void setScaMethods(AuthenticationObject[] scaMethods) {
        this.scaMethods = scaMethods;
    }

    public void setPsuMessage(String psuMessage) {
        this.psuMessage = psuMessage;
    }

    public void setTppMessages(MessageErrorCode[] tppMessages) {
        this.tppMessages = tppMessages;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setPisConsentId(String pisConsentId) {
        this.pisConsentId = pisConsentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentInitialisationResponse)) {
            return false;
        }
        PaymentInitialisationResponse other = (PaymentInitialisationResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        Amount this$transactionFees = this.getTransactionFees();
        Amount other$transactionFees = other.getTransactionFees();
        if (this$transactionFees == null ? other$transactionFees != null : !this$transactionFees.equals(other$transactionFees)) {
            return false;
        }
        if (this.isTransactionFeeIndicator() != other.isTransactionFeeIndicator()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScaMethods(), other.getScaMethods())) {
            return false;
        }
        String this$psuMessage = this.getPsuMessage();
        String other$psuMessage = other.getPsuMessage();
        if (this$psuMessage == null ? other$psuMessage != null : !this$psuMessage.equals(other$psuMessage)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTppMessages(), other.getTppMessages())) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$pisConsentId = this.getPisConsentId();
        String other$pisConsentId = other.getPisConsentId();
        return !(this$pisConsentId == null ? other$pisConsentId != null : !this$pisConsentId.equals(other$pisConsentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentInitialisationResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        Amount $transactionFees = this.getTransactionFees();
        result = result * 59 + ($transactionFees == null ? 43 : $transactionFees.hashCode());
        result = result * 59 + (this.isTransactionFeeIndicator() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getScaMethods());
        String $psuMessage = this.getPsuMessage();
        result = result * 59 + ($psuMessage == null ? 43 : $psuMessage.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTppMessages());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $pisConsentId = this.getPisConsentId();
        result = result * 59 + ($pisConsentId == null ? 43 : $pisConsentId.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentInitialisationResponse(transactionStatus=" + this.getTransactionStatus() + ", paymentId=" + this.getPaymentId() + ", transactionFees=" + this.getTransactionFees() + ", transactionFeeIndicator=" + this.isTransactionFeeIndicator() + ", scaMethods=" + Arrays.deepToString(this.getScaMethods()) + ", psuMessage=" + this.getPsuMessage() + ", tppMessages=" + Arrays.deepToString(this.getTppMessages()) + ", links=" + this.getLinks() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", iban=" + this.getIban() + ", pisConsentId=" + this.getPisConsentId() + ")";
    }
}

