/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="AuthenticationObject type", value="AuthenticationType")
public enum AuthenticationType {
    SMS_OTP("An SCA method, where an OTP linked to the transaction to be authorised is sent to the PSU through a SMS channel."),
    CHIP_OTP("An SCA method, where an OTP is generated by a chip card, e.g. an TOP derived from an EMV cryptogram. To contact the card, the PSU normally needs a (handheld) device. With this device, the PSU either reads the challenging data through a visual interface like flickering or the PSU types in the challenge through the device key pad. The device then derives an OTP from the challenge data and displays the OTP to the PSU."),
    PHOTO_OTP("An SCA method, where the challenge is a QR code or similar encoded visual data which can be read in by a consumer device or specific mobile app. The device resp. the specific app than derives an OTP from the visual challenge data and displays the OTP to the PSU."),
    PUSH_OTP("An OTP is pushed to a dedicated authentication APP and displayed to the PSU.");

    @ApiModelProperty(value="description", example="Will be defined later")
    private String description;

    private AuthenticationType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

